/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.KubernetesSupport;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.DeleteCustomResourceAction;
import org.citrusframework.kubernetes.actions.KubernetesAction;
import org.citrusframework.kubernetes.actions.KubernetesActionBuilder;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;

public class CreateCustomResourceAction
extends AbstractKubernetesAction
implements KubernetesAction {
    private final String type;
    private final Class<? extends HasMetadata> resourceType;
    private final String version;
    private final String kind;
    private final String group;
    private final String content;
    private final String filePath;

    public CreateCustomResourceAction(Builder builder) {
        super("create-custom-resource", builder);
        this.type = builder.type;
        this.resourceType = builder.resourceType;
        this.group = builder.group;
        this.version = builder.version;
        this.kind = builder.kind;
        this.content = builder.content;
        this.filePath = builder.filePath;
    }

    public void doExecute(TestContext context) {
        String resolvedResource;
        if (this.filePath != null) {
            try {
                resolvedResource = FileUtils.readToString((Resource)Resources.create((String)context.replaceDynamicContentInString(this.filePath)));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read custom resource file", (Throwable)e);
            }
        } else {
            resolvedResource = context.replaceDynamicContentInString(this.content);
        }
        if (this.resourceType != null) {
            HasMetadata resource = (HasMetadata)((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(this.resourceType).inNamespace(this.namespace(context))).load((InputStream)new ByteArrayInputStream(resolvedResource.getBytes(StandardCharsets.UTF_8)))).createOr(Updatable::update);
            if (this.isAutoRemoveResources()) {
                context.doFinally((TestActionBuilder)((DeleteCustomResourceAction.Builder)((Object)KubernetesActionBuilder.kubernetes().client(this.getKubernetesClient()).customResources().delete(resource.getMetadata().getName()).inNamespace(this.getNamespace()))).resourceType(this.resourceType));
            }
        } else {
            GenericKubernetesResource resource = (GenericKubernetesResource)((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)this.getKubernetesClient().genericKubernetesResources(KubernetesSupport.crdContext(context.replaceDynamicContentInString(this.type), context.replaceDynamicContentInString(this.group), context.replaceDynamicContentInString(this.kind), context.replaceDynamicContentInString(this.version))).inNamespace(this.namespace(context))).load((InputStream)new ByteArrayInputStream(resolvedResource.getBytes(StandardCharsets.UTF_8)))).createOr(Updatable::update);
            if (resource.get(new Object[]{"messages"}) != null) {
                throw new CitrusRuntimeException(String.format("Failed to create custom resource - %s", (Object[])resource.get(new Object[]{"messages"})));
            }
            if (this.isAutoRemoveResources()) {
                context.doFinally((TestActionBuilder)((DeleteCustomResourceAction.Builder)((Object)KubernetesActionBuilder.kubernetes().client(this.getKubernetesClient()).customResources().delete(resource.getMetadata().getName()).inNamespace(this.getNamespace()))).type(this.type).group(this.group).kind(this.kind).version(this.version));
            }
        }
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<CreateCustomResourceAction, Builder> {
        private String type;
        private Class<? extends HasMetadata> resourceType;
        private String version;
        private String kind;
        private String group;
        private String content;
        private String filePath;

        public Builder type(String resourceType) {
            this.type = resourceType;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            String[] groupAndVersion = apiVersion.split("/");
            this.group(groupAndVersion[0]);
            this.version(groupAndVersion[1]);
            return this;
        }

        public Builder resourceType(Class<CustomResource<?, ?>> resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder file(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder resource(CustomResource<?, ?> resource) {
            if (resource.getApiVersion() != null) {
                this.apiVersion(resource.getApiVersion());
            } else {
                this.version(resource.getClass().getAnnotation(Version.class).value());
            }
            if (resource.getKind() != null) {
                this.kind(resource.getKind());
            } else {
                this.kind(resource.getClass().getSimpleName());
            }
            if (resource.getGroup() != null) {
                this.group(resource.getGroup());
            } else {
                this.group(resource.getClass().getAnnotation(Group.class).value());
            }
            this.type(String.format("%ss.%s/%s", this.kind.toLowerCase(Locale.ENGLISH), this.group, this.version));
            this.content(KubernetesSupport.dumpYaml(resource));
            this.resourceType = resource.getClass();
            return this;
        }

        @Override
        public CreateCustomResourceAction doBuild() {
            return new CreateCustomResourceAction(this);
        }
    }
}

