/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import java.util.ArrayList;
import java.util.Collection;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.actions.ServiceDisconnectAction;

public class AgentDisconnectAction
extends ServiceDisconnectAction {
    private final String agentName;

    public AgentDisconnectAction(Builder builder) {
        super("agent-disconnect", builder);
        this.agentName = builder.agentName;
    }

    @Override
    public void doExecute(TestContext context) {
        this.logger.info("Disconnect from Kubernetes agent '{}'", (Object)this.agentName);
        if (!KubernetesSettings.isLocal()) {
            ((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.getKubernetesClient().resourceList(this.getAgentManifest()).inNamespace(this.namespace(context))).delete();
        }
        super.doExecute(context);
    }

    private Collection<? extends HasMetadata> getAgentManifest() {
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(this.agentName)).endMetadata()).build());
        resources.add(((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(this.agentName)).endMetadata()).build());
        return resources;
    }

    public static class Builder
    extends ServiceDisconnectAction.Builder {
        private String agentName = KubernetesSettings.getServiceName();

        @Override
        public Builder client(KubernetesClient kubernetesClient) {
            super.client(kubernetesClient);
            return this;
        }

        @Override
        public Builder service(String name) {
            this.agent(name);
            return this;
        }

        public Builder agent(String agentName) {
            this.agentName = agentName;
            return this;
        }

        @Override
        public AgentDisconnectAction doBuild() {
            super.service(this.agentName);
            return new AgentDisconnectAction(this);
        }
    }
}

