/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.jbang.CitrusJBang;
import org.citrusframework.kubernetes.CitrusAgentSettings;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.actions.KubernetesActionBuilder;
import org.citrusframework.kubernetes.actions.ServiceConnectAction;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;

public class AgentConnectAction
extends ServiceConnectAction {
    public static final String KUBERNETES_LABEL_NAME = "app.kubernetes.io/name";
    public static final String KUBERNETES_LABEL_MANAGED_BY = "app.kubernetes.io/managed-by";
    private final String agentName;
    private final String imageRegistry;
    private final String imageName;
    private final String imageTag;
    private final String testJar;

    public AgentConnectAction(Builder builder) {
        super("agent-connect", builder);
        this.agentName = builder.agentName;
        this.imageRegistry = builder.imageRegistry;
        this.imageName = builder.imageName;
        this.imageTag = builder.imageTag;
        this.testJar = builder.testJar;
    }

    @Override
    public void doExecute(TestContext context) {
        String agent = context.replaceDynamicContentInString(this.agentName);
        this.logger.info("Creating Kubernetes agent '{}'", (Object)agent);
        Path testJarPath = null;
        if (this.testJar != null) {
            testJarPath = Resources.create((String)this.testJar).getFile().toPath();
        }
        if (KubernetesSettings.isLocal()) {
            CitrusJBang jbang = new CitrusJBang().withEnv("CITRUS_AGENT_SERVER_PORT", Optional.ofNullable(this.localPort).orElse(CitrusAgentSettings.getServerPort())).withEnv("CITRUS_AGENT_SKIP_TESTS", "true");
            if (testJarPath != null) {
                jbang.withEnv("CITRUS_AGENT_TEST_JAR", testJarPath.getFileName().toString());
                jbang.addToClasspath(testJarPath.getFileName().toString());
                jbang.workingDir(testJarPath.getParent().toAbsolutePath());
            }
            jbang.agent().start();
        } else {
            boolean autoCreate;
            ((Resource)((NonNamespaceOperation)this.getKubernetesClient().configMaps().inNamespace(this.namespace(context))).resource((Object)AgentConnectAction.createTestSourceConfig(agent, testJarPath))).createOr(Updatable::update);
            boolean bl = autoCreate = !AgentConnectAction.serviceExists(this.getKubernetesClient(), agent, this.namespace(context));
            if (autoCreate) {
                ((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.getKubernetesClient().resourceList(AgentConnectAction.createDeploymentManifest(agent, this.getImage(), this.port, context)).inNamespace(this.namespace(context))).create();
            }
            if (autoCreate && this.isAutoRemoveResources()) {
                context.doFinally(KubernetesActionBuilder.kubernetes().client(this.getKubernetesClient()).agent().disconnect(agent).inNamespace(this.getNamespace()));
            }
        }
        this.logger.info("Kubernetes agent '{}' created successfully", (Object)agent);
        super.doExecute(context);
    }

    private static boolean serviceExists(KubernetesClient k8s, String agentName, String namespace) {
        return ((ServiceResource)((NonNamespaceOperation)k8s.services().inNamespace(namespace)).withName(agentName)).get() != null;
    }

    private static ConfigMap createTestSourceConfig(String agentName, Path testJar) {
        ConfigMapBuilder cmb = (ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(agentName + "-resources")).addToLabels("app", "citrus")).addToLabels(KUBERNETES_LABEL_NAME, agentName)).addToLabels(KUBERNETES_LABEL_MANAGED_BY, "citrus")).endMetadata();
        if (testJar != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Files.copy(testJar, out);
                cmb.withBinaryData(Collections.singletonMap(agentName + "-tests.jar", Base64.getEncoder().encodeToString(out.toByteArray())));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read test jar artifact", (Throwable)e);
            }
        }
        return cmb.build();
    }

    private static Collection<? extends HasMetadata> createDeploymentManifest(String agentName, String image, String port, TestContext context) {
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(agentName)).addToLabels("app", "citrus")).addToLabels(KUBERNETES_LABEL_NAME, agentName)).addToLabels(KUBERNETES_LABEL_MANAGED_BY, "citrus")).endMetadata()).withNewSpec().withNewTemplate().withNewMetadata().addToLabels("app", "citrus")).addToLabels(KUBERNETES_LABEL_NAME, agentName)).addToLabels(KUBERNETES_LABEL_MANAGED_BY, "citrus")).endMetadata()).editOrNewSpec().addToContainers(new Container[]{((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("citrus-agent")).withImage(image)).withImagePullPolicy("IfNotPresent")).withEnv(new EnvVar[]{((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("CITRUS_AGENT_TEST_JAR")).withValue("/deployments/resources/%s-tests.jar".formatted(agentName))).build(), ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("CITRUS_AGENT_SKIP_TESTS")).withValue("true")).build(), ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("CITRUS_AGENT_SERVER_PORT")).withValue("8080")).build()})).addToPorts(new ContainerPort[]{((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("http")).withContainerPort(Integer.valueOf(Integer.parseInt(context.replaceDynamicContentInString(port))))).withProtocol("TCP")).build()})).addToVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName("resources")).withMountPath("/deployments/resources")).build()})).build()})).addToVolumes(new Volume[]{((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("resources")).withConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(agentName + "-resources")).build())).build()})).endSpec()).endTemplate()).withSelector(((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(Map.of(KUBERNETES_LABEL_NAME, agentName))).build())).endSpec()).build());
        resources.add(((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(agentName)).addToLabels("app", "citrus")).addToLabels(KUBERNETES_LABEL_NAME, agentName)).addToLabels(KUBERNETES_LABEL_MANAGED_BY, "citrus")).endMetadata()).withNewSpec().withType("ClusterIP")).withSelector(Map.of(KUBERNETES_LABEL_NAME, agentName))).addToPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).withTargetPort(new IntOrString((Object)8080))).withProtocol("TCP")).build()})).endSpec()).build());
        return resources;
    }

    private String getImage() {
        if (StringUtils.hasText((String)this.imageRegistry)) {
            return "%s/%s:%s".formatted(this.imageRegistry, this.imageName, this.imageTag);
        }
        return "%s:%s".formatted(this.imageName, this.imageTag);
    }

    public static class Builder
    extends ServiceConnectAction.Builder {
        private String agentName = CitrusAgentSettings.getAgentName();
        private String imageName = CitrusAgentSettings.getImage();
        private String imageRegistry = "";
        private String imageTag = CitrusAgentSettings.getVersion();
        private String testJar;

        @Override
        public Builder client(KubernetesClient kubernetesClient) {
            super.client(kubernetesClient);
            return this;
        }

        @Override
        public Builder service(String name) {
            this.agent(name);
            return this;
        }

        public Builder agent(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public Builder image(String imageName) {
            if (imageName.contains(":")) {
                String[] tokens = imageName.split(":");
                return this.image(tokens[0], tokens[1]);
            }
            this.imageName = imageName;
            return this;
        }

        public Builder image(String imageName, String version) {
            this.imageName = imageName;
            this.imageTag = version;
            return this;
        }

        public Builder registry(String imageRegistry) {
            this.imageRegistry = imageRegistry;
            return this;
        }

        public Builder testJar(String testJar) {
            this.testJar = testJar;
            return this;
        }

        @Override
        public AgentConnectAction doBuild() {
            if (this.localPort == null) {
                this.localPort(CitrusAgentSettings.getServerPort());
            }
            super.service(this.agentName);
            super.doBuild();
            return new AgentConnectAction(this);
        }
    }
}

