/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "items"})
public class ListResult<T> {
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "v1";
    @NotNull
    @JsonProperty(value="kind")
    private String kind;
    @NotNull
    @JsonProperty
    private List<T> items;

    public ListResult() {
    }

    public ListResult(List<T> items) {
        if (items != null) {
            T t;
            if (items instanceof HasMetadata) {
                HasMetadata kubernetesResource = (HasMetadata)items;
                this.apiVersion = kubernetesResource.getApiVersion();
                this.kind = kubernetesResource.getKind();
            } else if (!items.isEmpty() && (t = items.get(0)) instanceof HasMetadata) {
                HasMetadata kubernetesResource = (HasMetadata)t;
                this.apiVersion = kubernetesResource.getApiVersion();
                this.kind = kubernetesResource.getKind() + "List";
            }
        }
        this.items = items;
    }

    public List<T> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<T>();
        }
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }
}

