/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.command.AbstractClientCommand;
import org.citrusframework.kubernetes.command.CommandResult;
import org.citrusframework.kubernetes.command.DeleteResult;
import org.citrusframework.kubernetes.command.KubernetesCommand;

public abstract class AbstractDeleteCommand<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>, C extends KubernetesCommand<T, DeleteResult>>
extends AbstractClientCommand<T, DeleteResult, L, R, C> {
    private final Class<T> type;
    private T resource;

    public AbstractDeleteCommand(String name, Class<T> type) {
        super("delete-" + name);
        this.type = type;
    }

    @Override
    public void execute(MixedOperation<T, L, R> operation, TestContext context) {
        KubernetesResourceList items;
        List results;
        boolean success = this.getParameters().containsKey("citrus_kubernetes_name") ? !(results = operation.delete()).isEmpty() : (this.resource != null ? !(results = ((Resource)operation.resource(this.resource)).delete()).isEmpty() : ((items = (KubernetesResourceList)operation.list()).getItems() != null && !items.getItems().isEmpty() ? operation.delete(items.getItems()) : true));
        DeleteResult result = new DeleteResult();
        if (this.resource != null) {
            result.setApVersion(result.getApVersion());
            result.setKind(result.getKind());
        } else {
            result.setKind(this.type.getSimpleName());
        }
        result.setSuccess(success);
        this.setCommandResult(new CommandResult<DeleteResult>(result));
    }

    public T getResource() {
        return this.resource;
    }

    public void setResource(T resource) {
        this.resource = resource;
    }
}

