/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.command.AbstractClientCommand;
import org.citrusframework.kubernetes.command.CommandResult;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;

public abstract class AbstractCreateCommand<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends io.fabric8.kubernetes.client.dsl.Resource<T>, C extends KubernetesCommand<T, T>>
extends AbstractClientCommand<T, T, L, R, C> {
    private T resource;
    private String template;
    private Resource templateResource;

    public AbstractCreateCommand(String name) {
        super("create-" + name);
    }

    @Override
    public void execute(MixedOperation<T, L, R> operation, TestContext context) {
        if (this.resource != null) {
            HasMetadata result = (HasMetadata)((io.fabric8.kubernetes.client.dsl.Resource)operation.resource(this.resource)).create();
            this.setCommandResult(new CommandResult<HasMetadata>(result));
        } else if (StringUtils.hasText((String)this.getTemplate()) || this.templateResource != null) {
            io.fabric8.kubernetes.client.dsl.Resource resource = (io.fabric8.kubernetes.client.dsl.Resource)operation.load(this.getTemplateAsStream(context));
            HasMetadata result = (HasMetadata)((io.fabric8.kubernetes.client.dsl.Resource)operation.resource((Object)((HasMetadata)resource.item()))).create();
            this.setCommandResult(new CommandResult<HasMetadata>(result));
        } else {
            HasMetadata result = (HasMetadata)((io.fabric8.kubernetes.client.dsl.Resource)operation.resource(this.specify(this.getResourceName(context), context))).create();
            this.setCommandResult(new CommandResult<HasMetadata>(result));
        }
    }

    protected abstract T specify(String var1, TestContext var2);

    protected InputStream getTemplateAsStream(TestContext context) {
        String templateYml;
        Resource resource = this.templateResource != null ? this.templateResource : FileUtils.getFileResource((String)this.template, (TestContext)context);
        try {
            templateYml = context.replaceDynamicContentInString(FileUtils.readToString((Resource)resource));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read template resource", (Throwable)e);
        }
        return new ByteArrayInputStream(templateYml.getBytes());
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public Resource getTemplateResource() {
        return this.templateResource;
    }

    public void setTemplateResource(Resource templateResource) {
        this.templateResource = templateResource;
    }

    public T getResource() {
        return this.resource;
    }

    public void setResource(T resource) {
        this.resource = resource;
    }
}

