/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.client.KubernetesClient;
import org.citrusframework.kubernetes.command.AbstractKubernetesCommand;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.util.StringUtils;

public abstract class AbstractClientCommand<T extends HasMetadata, O, L extends KubernetesResourceList<T>, R extends Resource<T>, C extends KubernetesCommand<T, O>>
extends AbstractKubernetesCommand<T, O, C> {
    public AbstractClientCommand(String name) {
        super(name);
    }

    @Override
    public final void execute(KubernetesClient kubernetesClient, TestContext context) {
        MixedOperation operation = this.operation(kubernetesClient, context);
        if (this.hasParameter("citrus_kubernetes_label")) {
            operation.withLabels(this.getLabels(this.getParameters().get("citrus_kubernetes_label").toString(), context));
            operation.withoutLabels(this.getWithoutLabels(this.getParameters().get("citrus_kubernetes_label").toString(), context));
        }
        if (operation != null && this.isNamespaceOperation()) {
            operation = this.hasParameter("citrus_kubernetes_namespace") ? (MixedOperation)operation.inNamespace(context.replaceDynamicContentInString(this.getParameters().get("citrus_kubernetes_namespace").toString())) : (StringUtils.hasText((String)kubernetesClient.getClient().getNamespace()) ? (MixedOperation)operation.inNamespace(kubernetesClient.getClient().getNamespace()) : (MixedOperation)operation.inAnyNamespace());
        }
        this.execute(operation, context);
    }

    protected boolean isNamespaceOperation() {
        return true;
    }

    protected String getResourceName(TestContext context) {
        if (this.hasParameter("citrus_kubernetes_name")) {
            return context.replaceDynamicContentInString(this.getParameters().get("citrus_kubernetes_name").toString());
        }
        return null;
    }

    protected abstract void execute(MixedOperation<T, L, R> var1, TestContext var2);

    protected abstract MixedOperation<T, L, R> operation(KubernetesClient var1, TestContext var2);
}

