/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.config.xml;

import org.citrusframework.kubernetes.command.CreatePod;
import org.citrusframework.kubernetes.config.xml.KubernetesExecuteActionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreatePodActionParser
extends KubernetesExecuteActionParser<CreatePod> {
    public CreatePodActionParser() {
        super(CreatePod.class);
    }

    @Override
    protected CreatePod parseCommand(CreatePod command, Element element, ParserContext parserContext) {
        Element containerElement;
        Element specElement;
        Element templateElement = DomUtils.getChildElementByTagName((Element)element, (String)"template");
        if (templateElement != null) {
            command.setTemplate(templateElement.getAttribute("file"));
        }
        if ((specElement = DomUtils.getChildElementByTagName((Element)element, (String)"spec")) != null && (containerElement = DomUtils.getChildElementByTagName((Element)specElement, (String)"container")) != null) {
            command.setContainerName(containerElement.getAttribute("name"));
            command.setContainerCommand(containerElement.getAttribute("command"));
            command.setImage(containerElement.getAttribute("image"));
            command.setPullPolicy(containerElement.getAttribute("pull-policy"));
            Element portsElement = DomUtils.getChildElementByTagName((Element)containerElement, (String)"ports");
            if (portsElement != null) {
                if (portsElement.hasAttribute("protocol")) {
                    command.setProtocol(portsElement.getAttribute("protocol"));
                }
                if (portsElement.hasAttribute("port")) {
                    command.setContainerPort(portsElement.getAttribute("port"));
                }
            }
        }
        return command;
    }
}

