/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPortFluent;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.client.KubernetesClient;
import org.citrusframework.kubernetes.command.AbstractCreateCommand;
import org.citrusframework.util.StringUtils;

public class CreatePod
extends AbstractCreateCommand<Pod, DoneablePod, CreatePod> {
    private String image;
    private String pullPolicy = "IfNotPresent";
    private String containerName;
    private String containerCommand;
    private String containerPort;
    private String protocol = "TCP";
    private String restartPolicy = "Always";

    public CreatePod() {
        super("pod");
    }

    @Override
    protected ClientMixedOperation<Pod, ? extends KubernetesResourceList, DoneablePod, ? extends ClientResource<Pod, DoneablePod>> operation(KubernetesClient kubernetesClient, TestContext context) {
        return kubernetesClient.getClient().pods();
    }

    @Override
    protected DoneablePod specify(DoneablePod pod, TestContext context) {
        PodFluent.MetadataNested metadata = pod.editOrNewMetadata();
        if (this.getParameters().containsKey("citrus_kubernetes_name")) {
            metadata.withName(this.getParameter("citrus_kubernetes_name", context));
        }
        if (this.getParameters().containsKey("citrus_kubernetes_label")) {
            metadata.withLabels(this.getLabels(this.getParameters().get("citrus_kubernetes_label").toString(), context));
        }
        if (this.getParameters().containsKey("citrus_kubernetes_namespace")) {
            metadata.withNamespace(this.getParameter("citrus_kubernetes_namespace", context));
        }
        metadata.endMetadata();
        PodFluent.SpecNested spec = pod.editOrNewSpec();
        if (StringUtils.hasText((String)this.image)) {
            PodSpecFluent.ContainersNested containers = spec.addNewContainer();
            ContainerFluent container = containers.withImage(context.replaceDynamicContentInString(this.image));
            if (StringUtils.hasText((String)this.containerName)) {
                container.withName(context.replaceDynamicContentInString(this.containerName));
            }
            if (StringUtils.hasText((String)this.containerCommand)) {
                container.withCommand(new String[]{context.replaceDynamicContentInString(this.containerCommand)});
            }
            if (StringUtils.hasText((String)this.containerPort)) {
                ContainerFluent.PortsNested ports = container.addNewPort();
                ContainerPortFluent port = ports.withContainerPort(Integer.valueOf(context.replaceDynamicContentInString(this.containerPort)));
                port.withProtocol(context.replaceDynamicContentInString(this.protocol));
                ports.endPort();
            }
            containers.endContainer();
        }
        spec.withRestartPolicy(this.restartPolicy);
        spec.endSpec();
        return pod;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getContainerCommand() {
        return this.containerCommand;
    }

    public void setContainerCommand(String containerCommand) {
        this.containerCommand = containerCommand;
    }

    public String getPullPolicy() {
        return this.pullPolicy;
    }

    public void setPullPolicy(String pullPolicy) {
        this.pullPolicy = pullPolicy;
    }

    public String getContainerPort() {
        return this.containerPort;
    }

    public void setContainerPort(String containerPort) {
        this.containerPort = containerPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public Pod getPod() {
        return (Pod)this.getResource();
    }

    public CreatePod setPod(Pod pod) {
        this.setResource(pod);
        return this;
    }
}

