/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.command.AbstractClientCommand;
import org.citrusframework.kubernetes.command.CommandResult;
import org.citrusframework.kubernetes.command.DeleteResult;
import org.citrusframework.kubernetes.command.KubernetesCommand;

public abstract class AbstractDeleteCommand<D extends DeleteResult, R extends KubernetesResource, T extends KubernetesCommand<D>>
extends AbstractClientCommand<ClientMixedOperation<R, ? extends KubernetesResourceList, ? extends Doneable<R>, ? extends ClientResource<R, ? extends Doneable<R>>>, D, T> {
    private Class<R> type;
    private R resource;

    public AbstractDeleteCommand(String name, Class<R> type) {
        super("delete-" + name);
        this.type = type;
    }

    @Override
    public void execute(ClientMixedOperation<R, ? extends KubernetesResourceList, ? extends Doneable<R>, ? extends ClientResource<R, ? extends Doneable<R>>> operation, TestContext context) {
        KubernetesResourceList items;
        Boolean success = this.getParameters().containsKey("citrus_kubernetes_name") ? (Boolean)operation.delete() : ((items = (KubernetesResourceList)operation.list()).getItems() != null && !items.getItems().isEmpty() ? (Boolean)operation.delete(items.getItems()) : Boolean.valueOf(false));
        DeleteResult result = new DeleteResult();
        result.setType(this.type.getSimpleName());
        result.setSuccess(success);
        this.setCommandResult(new CommandResult<DeleteResult>(result));
    }

    public R getResource() {
        return this.resource;
    }

    public void setResource(R resource) {
        this.resource = resource;
    }
}

