/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.command.AbstractClientCommand;
import org.citrusframework.kubernetes.command.CommandResult;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;

public abstract class AbstractCreateCommand<R extends KubernetesResource, D extends Doneable<R>, T extends KubernetesCommand<R>>
extends AbstractClientCommand<ClientMixedOperation<R, ? extends KubernetesResourceList, D, ? extends ClientResource<R, D>>, R, T> {
    private R resource;
    private String template;
    private Resource templateResource;

    public AbstractCreateCommand(String name) {
        super("create-" + name);
    }

    @Override
    public void execute(ClientMixedOperation<R, ? extends KubernetesResourceList, D, ? extends ClientResource<R, D>> operation, TestContext context) {
        if (this.resource != null) {
            operation.create((Object[])new KubernetesResource[]{this.resource});
            this.setCommandResult(new CommandResult<R>(this.resource));
        } else if (StringUtils.hasText((String)this.getTemplate()) || this.templateResource != null) {
            KubernetesResource resource = (KubernetesResource)((ClientResource)operation.load(this.getTemplateAsStream(context))).get();
            operation.create((Object[])new KubernetesResource[]{resource});
            this.setCommandResult(new CommandResult<KubernetesResource>(resource));
        } else {
            this.setCommandResult(new CommandResult<KubernetesResource>((KubernetesResource)this.specify((Doneable)operation.createNew(), context).done()));
        }
    }

    protected abstract D specify(D var1, TestContext var2);

    protected InputStream getTemplateAsStream(TestContext context) {
        String templateYml;
        Resource resource = this.templateResource != null ? this.templateResource : FileUtils.getFileResource((String)this.template, (TestContext)context);
        try {
            templateYml = context.replaceDynamicContentInString(FileUtils.readToString((Resource)resource));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read template resource", (Throwable)e);
        }
        return new ByteArrayInputStream(templateYml.getBytes());
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public Resource getTemplateResource() {
        return this.templateResource;
    }

    public void setTemplateResource(Resource templateResource) {
        this.templateResource = templateResource;
    }

    public R getResource() {
        return this.resource;
    }

    public void setResource(R resource) {
        this.resource = resource;
    }
}

