/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.ConfigBuilder;
import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.kubernetes.client.KubernetesClient;
import org.citrusframework.kubernetes.message.KubernetesMessageConverter;

public class KubernetesClientBuilder
extends AbstractEndpointBuilder<KubernetesClient> {
    private KubernetesClient endpoint = new KubernetesClient();
    private ConfigBuilder config = new ConfigBuilder();

    public KubernetesClient build() {
        this.endpoint.getEndpointConfiguration().setKubernetesClientConfig(this.config.build());
        return (KubernetesClient)super.build();
    }

    protected KubernetesClient getEndpoint() {
        return this.endpoint;
    }

    public KubernetesClientBuilder url(String url) {
        this.config.withMasterUrl(url);
        return this;
    }

    public KubernetesClientBuilder version(String version) {
        this.config.withApiVersion(version);
        return this;
    }

    public KubernetesClientBuilder username(String username) {
        this.config.withUsername(username);
        return this;
    }

    public KubernetesClientBuilder password(String password) {
        this.config.withPassword(password);
        return this;
    }

    public KubernetesClientBuilder oauthToken(String oauthToken) {
        this.config.withOauthToken(oauthToken);
        return this;
    }

    public KubernetesClientBuilder namespace(String namespace) {
        this.config.withNamespace(namespace);
        return this;
    }

    public KubernetesClientBuilder certFile(String certFile) {
        this.config.withCaCertFile(certFile);
        return this;
    }

    public KubernetesClientBuilder messageConverter(KubernetesMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public KubernetesClientBuilder objectMapper(ObjectMapper objectMapper) {
        this.endpoint.getEndpointConfiguration().setObjectMapper(objectMapper);
        return this;
    }
}

