/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.message;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.command.CommandResult;
import org.citrusframework.kubernetes.command.CreatePod;
import org.citrusframework.kubernetes.command.CreateService;
import org.citrusframework.kubernetes.command.DeletePod;
import org.citrusframework.kubernetes.command.DeleteService;
import org.citrusframework.kubernetes.command.GetPod;
import org.citrusframework.kubernetes.command.GetService;
import org.citrusframework.kubernetes.command.Info;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.kubernetes.command.ListEndpoints;
import org.citrusframework.kubernetes.command.ListEvents;
import org.citrusframework.kubernetes.command.ListNamespaces;
import org.citrusframework.kubernetes.command.ListNodes;
import org.citrusframework.kubernetes.command.ListPods;
import org.citrusframework.kubernetes.command.ListReplicationControllers;
import org.citrusframework.kubernetes.command.ListServices;
import org.citrusframework.kubernetes.command.WatchEventResult;
import org.citrusframework.kubernetes.command.WatchNamespaces;
import org.citrusframework.kubernetes.command.WatchNodes;
import org.citrusframework.kubernetes.command.WatchPods;
import org.citrusframework.kubernetes.command.WatchReplicationControllers;
import org.citrusframework.kubernetes.command.WatchServices;
import org.citrusframework.kubernetes.endpoint.KubernetesEndpointConfiguration;
import org.citrusframework.kubernetes.message.KubernetesMessage;
import org.citrusframework.kubernetes.model.KubernetesRequest;
import org.citrusframework.kubernetes.model.KubernetesResponse;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageConverter;
import org.springframework.util.StringUtils;

public class KubernetesMessageConverter
implements MessageConverter<KubernetesCommand<?>, KubernetesCommand<?>, KubernetesEndpointConfiguration> {
    public KubernetesCommand<?> convertOutbound(Message message, KubernetesEndpointConfiguration endpointConfiguration, TestContext context) {
        KubernetesCommand<?> command = this.getCommand(message, endpointConfiguration);
        this.convertOutbound(command, message, endpointConfiguration, context);
        return command;
    }

    public void convertOutbound(KubernetesCommand<?> command, Message message, KubernetesEndpointConfiguration endpointConfiguration, TestContext context) {
    }

    public Message convertInbound(KubernetesCommand<?> command, KubernetesEndpointConfiguration endpointConfiguration, TestContext context) {
        KubernetesResponse response = new KubernetesResponse();
        KubernetesMessage message = KubernetesMessage.response(response);
        response.setCommand(command.getName());
        message.setHeader("citrus_kubernetes_command", response.getCommand());
        for (Map.Entry<String, Object> header : this.createMessageHeaders(command).entrySet()) {
            message.setHeader(header.getKey(), header.getValue());
        }
        CommandResult<?> commandResult = command.getCommandResult();
        if (commandResult != null) {
            if (commandResult.getResult() != null) {
                response.setResult((KubernetesResource<?>)commandResult.getResult());
            }
            if (commandResult.hasError()) {
                response.setError(commandResult.getError().getMessage());
            }
            if (commandResult instanceof WatchEventResult) {
                response.setAction(((WatchEventResult)commandResult).getAction().name());
                message.setHeader("citrus_kubernetes_action", ((WatchEventResult)commandResult).getAction().name());
            }
        }
        return message;
    }

    private KubernetesCommand<?> getCommandByName(String commandName) {
        if (!StringUtils.hasText((String)commandName)) {
            throw new CitrusRuntimeException("Missing command name property");
        }
        switch (commandName) {
            case "info": {
                return new Info();
            }
            case "list-events": {
                return new ListEvents();
            }
            case "list-endpoints": {
                return new ListEndpoints();
            }
            case "create-pod": {
                return new CreatePod();
            }
            case "get-pod": {
                return new GetPod();
            }
            case "delete-pod": {
                return new DeletePod();
            }
            case "list-pods": {
                return new ListPods();
            }
            case "watch-pods": {
                return new WatchPods();
            }
            case "list-namespaces": {
                return new ListNamespaces();
            }
            case "watch-namespaces": {
                return new WatchNamespaces();
            }
            case "list-nodes": {
                return new ListNodes();
            }
            case "watch-nodes": {
                return new WatchNodes();
            }
            case "list-replication-controllers": {
                return new ListReplicationControllers();
            }
            case "watch-replication-controllers": {
                return new WatchReplicationControllers();
            }
            case "create-service": {
                return new CreateService();
            }
            case "get-service": {
                return new GetService();
            }
            case "delete-service": {
                return new DeleteService();
            }
            case "list-services": {
                return new ListServices();
            }
            case "watch-services": {
                return new WatchServices();
            }
        }
        throw new CitrusRuntimeException("Unknown kubernetes command: " + commandName);
    }

    private Map<String, Object> createMessageHeaders(KubernetesCommand<?> command) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("citrus_kubernetes_command", command.getName());
        for (Map.Entry<String, Object> entry : command.getParameters().entrySet()) {
            headers.put(entry.getKey(), entry.getValue());
        }
        return headers;
    }

    private KubernetesCommand<?> getCommand(Message message, KubernetesEndpointConfiguration endpointConfiguration) {
        KubernetesCommand<?> command;
        Object payload = message.getPayload();
        if (message instanceof KubernetesMessage) {
            command = this.createCommandFromRequest((KubernetesRequest)message.getPayload(KubernetesRequest.class));
        } else if (message.getHeaders().containsKey("citrus_kubernetes_command") && (payload == null || !StringUtils.hasText((String)payload.toString()))) {
            command = this.getCommandByName(message.getHeader("citrus_kubernetes_command").toString());
        } else if (payload instanceof KubernetesCommand) {
            command = (KubernetesCommand<?>)payload;
        } else {
            try {
                KubernetesRequest request = (KubernetesRequest)endpointConfiguration.getObjectMapper().readValue((String)message.getPayload(String.class), KubernetesRequest.class);
                command = this.createCommandFromRequest(request);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read kubernetes request from payload", (Throwable)e);
            }
        }
        if (command == null) {
            throw new CitrusRuntimeException("Unable to create proper Kubernetes command from payload: " + payload);
        }
        return command;
    }

    private KubernetesCommand<?> createCommandFromRequest(KubernetesRequest request) {
        KubernetesCommand<?> command = this.getCommandByName(request.getCommand());
        if (StringUtils.hasText((String)request.getName())) {
            command.getParameters().put("citrus_kubernetes_name", request.getName());
        }
        if (StringUtils.hasText((String)request.getNamespace())) {
            command.getParameters().put("citrus_kubernetes_namespace", request.getNamespace());
        }
        if (StringUtils.hasText((String)request.getLabel())) {
            command.getParameters().put("citrus_kubernetes_label", request.getLabel());
        }
        return command;
    }
}

