/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.message;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import java.io.IOException;
import java.util.Map;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.kubernetes.model.KubernetesRequest;
import org.citrusframework.kubernetes.model.KubernetesResponse;
import org.citrusframework.message.DefaultMessage;

public class KubernetesMessage
extends DefaultMessage {
    private ObjectMapper mapper = new ObjectMapper();
    private KubernetesRequest request;
    private KubernetesResponse response;

    private KubernetesMessage() {
    }

    private KubernetesMessage(Object payload, Map<String, Object> headers) {
        super(payload, headers);
    }

    private KubernetesMessage(KubernetesRequest request) {
        this.request = request;
    }

    private KubernetesMessage(KubernetesResponse response) {
        this.response = response;
    }

    public static KubernetesMessage response(KubernetesResponse response) {
        return new KubernetesMessage(response);
    }

    public static KubernetesMessage response(String command, KubernetesResource<?> result) {
        KubernetesResponse response = new KubernetesResponse();
        response.setCommand(command);
        response.setResult(result);
        return new KubernetesMessage(response);
    }

    public static KubernetesMessage response(String command, Watcher.Action action, KubernetesResource<?> result) {
        KubernetesResponse response = new KubernetesResponse();
        response.setCommand(command);
        response.setResult(result);
        response.setAction(action.name());
        return new KubernetesMessage(response);
    }

    public static KubernetesMessage response(String command, KubernetesClientException error) {
        return KubernetesMessage.response(command, error.getMessage());
    }

    public static KubernetesMessage response(String command, String error) {
        KubernetesResponse response = new KubernetesResponse();
        response.setCommand(command);
        response.setError(error);
        return new KubernetesMessage(response);
    }

    public static KubernetesMessage request(KubernetesRequest request) {
        return new KubernetesMessage(request);
    }

    public static KubernetesMessage request(KubernetesCommand<?> command) {
        KubernetesRequest request = new KubernetesRequest();
        request.setCommand(command.getName());
        for (Map.Entry<String, Object> entry : command.getParameters().entrySet()) {
            if (entry.getKey().equals("citrus_kubernetes_name")) {
                request.setName(entry.getValue().toString());
            }
            if (entry.getKey().equals("citrus_kubernetes_namespace")) {
                request.setNamespace(entry.getValue().toString());
            }
            if (!entry.getKey().equals("citrus_kubernetes_label")) continue;
            request.setLabel(entry.getValue().toString());
        }
        return new KubernetesMessage(request);
    }

    public <T> T getPayload(Class<T> type) {
        try {
            if (KubernetesRequest.class.isAssignableFrom(type)) {
                if (this.getPayload() instanceof KubernetesRequest) {
                    return (T)this.getPayload();
                }
                return (T)this.mapper.readValue(this.getPayload(String.class), KubernetesRequest.class);
            }
            if (KubernetesResponse.class.isAssignableFrom(type)) {
                if (this.getPayload() instanceof KubernetesResponse) {
                    return (T)this.getPayload();
                }
                return (T)this.mapper.readValue(this.getPayload(String.class), KubernetesRequest.class);
            }
            if (String.class.equals(type)) {
                if (this.request != null) {
                    return (T)this.mapper.writeValueAsString((Object)this.request);
                }
                if (this.response != null) {
                    return (T)this.mapper.writeValueAsString((Object)this.response);
                }
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to convert payload to required type: " + type, (Throwable)e);
        }
        return (T)super.getPayload(type);
    }
}

