/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.config.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractTestActionFactoryBean;
import org.citrusframework.config.xml.DescriptionElementParser;
import org.citrusframework.kubernetes.actions.KubernetesExecuteAction;
import org.citrusframework.kubernetes.client.KubernetesClient;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KubernetesExecuteActionParser<T extends KubernetesCommand>
implements BeanDefinitionParser {
    private Class<T> commandType;

    public KubernetesExecuteActionParser(Class<T> commandType) {
        this.commandType = commandType;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(KubernetesExecuteActionFactoryBean.class);
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)beanDefinition);
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("client"), (String)"kubernetesClient");
        T command = this.parseCommand(this.createCommand(this.commandType), element, parserContext);
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            Node attribute = element.getAttributes().item(i);
            if (attribute.getNodeName().equals("client")) continue;
            command.getParameters().put("citrus_kubernetes_" + attribute.getNodeName(), attribute.getNodeValue());
        }
        Element controlCmdResult = DomUtils.getChildElementByTagName((Element)element, (String)"validate");
        if (controlCmdResult != null) {
            Element resultElement = DomUtils.getChildElementByTagName((Element)controlCmdResult, (String)"result");
            if (resultElement != null) {
                beanDefinition.addPropertyValue("commandResult", (Object)DomUtils.getTextValue((Element)resultElement));
            }
            HashMap<String, String> pathExpressions = new HashMap<String, String>();
            List pathElements = DomUtils.getChildElementsByTagName((Element)controlCmdResult, (String)"element");
            for (Element messageValue : pathElements) {
                pathExpressions.put(messageValue.getAttribute("path"), messageValue.getAttribute("value"));
            }
            if (!pathExpressions.isEmpty()) {
                beanDefinition.addPropertyValue("commandResultExpressions", pathExpressions);
            }
        }
        beanDefinition.addPropertyValue("command", command);
        return beanDefinition.getBeanDefinition();
    }

    protected T parseCommand(T command, Element element, ParserContext parserContext) {
        return command;
    }

    private T createCommand(Class<T> commandType) {
        try {
            return (T)((KubernetesCommand)commandType.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BeanCreationException("Failed to create Kubernetes command of type: " + commandType, (Throwable)e);
        }
    }

    public static class KubernetesExecuteActionFactoryBean
    extends AbstractTestActionFactoryBean<KubernetesExecuteAction, KubernetesExecuteAction.Builder> {
        @Autowired(required=false)
        @Qualifier(value="k8sClient")
        private KubernetesClient kubernetesClient;
        @Autowired(required=false)
        @Qualifier(value="defaultJsonMessageValidator")
        private MessageValidator<? extends ValidationContext> jsonMessageValidator;
        @Autowired(required=false)
        @Qualifier(value="defaultJsonPathMessageValidator")
        private MessageValidator<? extends ValidationContext> jsonPathMessageValidator;
        private final KubernetesExecuteAction.Builder builder = new KubernetesExecuteAction.Builder();

        public void setCommand(KubernetesCommand<?> command) {
            this.builder.command(command);
        }

        public void setKubernetesClient(KubernetesClient kubernetesClient) {
            this.builder.client(kubernetesClient);
        }

        public void setCommandResult(String controlCommandResult) {
            this.builder.result(controlCommandResult);
        }

        public void setCommandResultExpressions(Map<String, Object> commandResultExpressions) {
            commandResultExpressions.forEach(this.builder::validate);
        }

        public KubernetesExecuteAction getObject() throws Exception {
            if (this.kubernetesClient != null) {
                this.builder.client(this.kubernetesClient);
            }
            if (this.jsonMessageValidator != null) {
                this.builder.validator(this.jsonMessageValidator);
            }
            if (this.jsonPathMessageValidator != null) {
                this.builder.pathExpressionValidator(this.jsonPathMessageValidator);
            }
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return KubernetesExecuteAction.class;
        }

        public KubernetesExecuteAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

