/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.config.annotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.kubernetes.client.KubernetesClient;
import org.citrusframework.kubernetes.client.KubernetesClientBuilder;
import org.citrusframework.kubernetes.config.annotation.KubernetesClientConfig;
import org.citrusframework.kubernetes.message.KubernetesMessageConverter;
import org.citrusframework.spi.ReferenceResolver;
import org.springframework.util.StringUtils;

public class KubernetesClientConfigParser
implements AnnotationConfigParser<KubernetesClientConfig, KubernetesClient> {
    public KubernetesClient parse(KubernetesClientConfig annotation, ReferenceResolver referenceResolver) {
        KubernetesClientBuilder builder = new KubernetesClientBuilder();
        if (StringUtils.hasText((String)annotation.url())) {
            builder.url(annotation.url());
        }
        if (StringUtils.hasText((String)annotation.version())) {
            builder.version(annotation.version());
        }
        if (StringUtils.hasText((String)annotation.username())) {
            builder.username(annotation.username());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.namespace())) {
            builder.namespace(annotation.namespace());
        }
        if (StringUtils.hasText((String)annotation.certFile())) {
            builder.certFile(annotation.certFile());
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((KubernetesMessageConverter)referenceResolver.resolve(annotation.messageConverter(), KubernetesMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.objectMapper())) {
            builder.objectMapper((ObjectMapper)referenceResolver.resolve(annotation.objectMapper(), ObjectMapper.class));
        }
        return builder.build();
    }
}

