/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePortFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.client.KubernetesClient;
import org.citrusframework.kubernetes.command.AbstractCreateCommand;
import org.springframework.util.StringUtils;

public class CreateService
extends AbstractCreateCommand<Service, DoneableService, CreateService> {
    private String selector;
    private String port;
    private String targetPort;
    private String nodePort;
    private String protocol = "TCP";

    public CreateService() {
        super("pod");
    }

    @Override
    protected ClientMixedOperation<Service, ? extends KubernetesResourceList, DoneableService, ? extends ClientResource<Service, DoneableService>> operation(KubernetesClient kubernetesClient, TestContext context) {
        return kubernetesClient.getClient().services();
    }

    @Override
    protected DoneableService specify(DoneableService service, TestContext context) {
        ServiceFluent.MetadataNested metadata = service.editOrNewMetadata();
        if (this.getParameters().containsKey("citrus_kubernetes_name")) {
            metadata.withName(this.getParameter("citrus_kubernetes_name", context));
        }
        if (this.getParameters().containsKey("citrus_kubernetes_label")) {
            metadata.withLabels(this.getLabels(this.getParameters().get("citrus_kubernetes_label").toString(), context));
        }
        if (this.getParameters().containsKey("citrus_kubernetes_namespace")) {
            metadata.withNamespace(this.getParameter("citrus_kubernetes_namespace", context));
        }
        metadata.endMetadata();
        ServiceFluent.SpecNested spec = service.editOrNewSpec();
        if (StringUtils.hasText((String)this.selector)) {
            spec.withSelector(this.getLabels(this.selector, context));
        }
        if (StringUtils.hasText((String)this.port)) {
            ServiceSpecFluent.PortsNested ports = spec.addNewPort();
            ServicePortFluent container = ports.withPort(Integer.valueOf(context.replaceDynamicContentInString(this.port)));
            if (StringUtils.hasText((String)this.targetPort)) {
                container.withNewTargetPort(Integer.valueOf(context.replaceDynamicContentInString(this.targetPort)));
            } else {
                container.withNewTargetPort();
            }
            if (StringUtils.hasText((String)this.nodePort)) {
                container.withNodePort(Integer.valueOf(context.replaceDynamicContentInString(this.nodePort)));
            }
            container.withProtocol(context.replaceDynamicContentInString(this.protocol));
            ports.endPort();
        }
        spec.endSpec();
        return service;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getTargetPort() {
        return this.targetPort;
    }

    public void setTargetPort(String targetPort) {
        this.targetPort = targetPort;
    }

    public String getNodePort() {
        return this.nodePort;
    }

    public void setNodePort(String nodePort) {
        this.nodePort = nodePort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Service getService() {
        return (Service)this.getResource();
    }

    public CreateService setService(Service service) {
        this.setResource(service);
        return this;
    }
}

