/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.MessageTimeoutException;
import org.citrusframework.kubernetes.command.AbstractClientCommand;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.kubernetes.command.WatchEventResult;

public abstract class AbstractWatchCommand<R extends KubernetesResource, T extends KubernetesCommand<R>>
extends AbstractClientCommand<ClientNonNamespaceOperation, R, T> {
    private Watch watch;
    private long timeout = 5000L;
    private BlockingQueue<WatchEventResult<R>> results = new ArrayBlockingQueue<WatchEventResult<R>>(1);
    private WatchEventResult<R> cachedResult;

    public AbstractWatchCommand(String name) {
        super("watch-" + name);
    }

    @Override
    public void execute(ClientNonNamespaceOperation operation, TestContext context) {
        this.watch = (Watch)operation.watch((Object)new Watcher<R>(){

            public void eventReceived(Watcher.Action action, R resource) {
                if (AbstractWatchCommand.this.results.isEmpty() && AbstractWatchCommand.this.cachedResult == null) {
                    AbstractWatchCommand.this.results.add(new WatchEventResult(resource, action));
                } else {
                    AbstractWatchCommand.this.log.debug("Ignoring watch result: " + action.name());
                }
            }

            public void onClose(KubernetesClientException cause) {
                if (AbstractWatchCommand.this.results.isEmpty() && AbstractWatchCommand.this.cachedResult == null) {
                    AbstractWatchCommand.this.results.add(new WatchEventResult(cause));
                }
            }
        });
    }

    @Override
    public WatchEventResult<R> getCommandResult() {
        if (this.cachedResult != null) {
            return this.cachedResult;
        }
        try {
            WatchEventResult<R> watchEventResult = this.results.poll(this.timeout, TimeUnit.MILLISECONDS);
            if (watchEventResult == null) {
                throw new MessageTimeoutException(this.timeout, "watchEventResultQueue");
            }
            try {
                this.watch.close();
            }
            catch (KubernetesClientException e) {
                this.log.warn("Failed to gracefully close watch", (Throwable)e);
            }
            watchEventResult.setWatch(this.watch);
            this.cachedResult = watchEventResult;
            return watchEventResult;
        }
        catch (InterruptedException e) {
            throw new CitrusRuntimeException("Failed to wait for watch result", (Throwable)e);
        }
    }

    public Watch getWatch() {
        return this.watch;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

