/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.client.KubernetesClient;
import org.citrusframework.kubernetes.command.AbstractKubernetesCommand;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.springframework.util.StringUtils;

public abstract class AbstractClientCommand<O extends ClientNonNamespaceOperation, R extends KubernetesResource, T extends KubernetesCommand<R>>
extends AbstractKubernetesCommand<R, T> {
    public AbstractClientCommand(String name) {
        super(name);
    }

    @Override
    public final void execute(KubernetesClient kubernetesClient, TestContext context) {
        Object operation = this.operation(kubernetesClient, context);
        if (this.hasParameter("citrus_kubernetes_label")) {
            operation.withLabels(this.getLabels(this.getParameters().get("citrus_kubernetes_label").toString(), context));
            operation.withoutLabels(this.getWithoutLabels(this.getParameters().get("citrus_kubernetes_label").toString(), context));
        }
        if (this.hasParameter("citrus_kubernetes_name")) {
            operation = (ClientNonNamespaceOperation)operation.withName(context.replaceDynamicContentInString(this.getParameters().get("citrus_kubernetes_name").toString()));
        }
        if (operation instanceof ClientMixedOperation) {
            operation = this.hasParameter("citrus_kubernetes_namespace") ? (ClientNonNamespaceOperation)((ClientMixedOperation)operation).inNamespace(context.replaceDynamicContentInString(this.getParameters().get("citrus_kubernetes_namespace").toString())) : (StringUtils.hasText((String)kubernetesClient.getClient().getNamespace()) ? (ClientNonNamespaceOperation)((ClientMixedOperation)operation).inNamespace(kubernetesClient.getClient().getNamespace()) : (ClientNonNamespaceOperation)((ClientMixedOperation)operation).inAnyNamespace());
        }
        this.execute(operation, context);
    }

    protected abstract void execute(O var1, TestContext var2);

    protected abstract O operation(KubernetesClient var1, TestContext var2);
}

