/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.util;

import java.util.ArrayList;
import java.util.List;

public class Tree<T> {
    private final ParentChildNode<T> root;

    public Tree(T rootData) {
        this.root = new ParentChildNode<T>(rootData, null, true);
    }

    public List<ParentChildNode<T>> getBranchNodes(ParentChildNode<T> stem) {
        ArrayList<ParentChildNode<T>> retList = new ArrayList<ParentChildNode<T>>();
        retList.add(stem);
        for (ParentChildNode<T> node : stem.getChildren()) {
            retList.addAll(this.getBranchNodes(node));
        }
        return retList;
    }

    public List<ParentChildNode<T>> getAllNodes() {
        return this.getBranchNodes(this.root);
    }

    public static class ParentChildNode<U> {
        private final ParentChildNode<U> parent;
        private final boolean isRoot;
        private U data;
        private final ArrayList<ParentChildNode<U>> children;

        private ParentChildNode(U data, ParentChildNode<U> parent, boolean isRoot) {
            this.parent = parent;
            this.data = data;
            this.isRoot = isRoot;
            this.children = new ArrayList();
        }

        public ParentChildNode(U data, ParentChildNode<U> parent) {
            this(data, parent, false);
        }

        public ParentChildNode<U> constructAsChild(U data) {
            ParentChildNode<U> node = new ParentChildNode<U>(data, this);
            this.children.add(node);
            return node;
        }

        public U getData() {
            return this.data;
        }

        public void setData(U data) {
            this.data = data;
        }

        public List<ParentChildNode<U>> getChildren() {
            return this.children;
        }

        public ParentChildNode<U> getParent() {
            return this.parent;
        }

        public boolean isRoot() {
            return this.isRoot;
        }
    }
}

