/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class NodeGraph<T> {
    private int idIndex = 0;
    private HashMap<Integer, Node> nodes = new HashMap();
    private HashMap<Integer, ArrayList<Integer>> connectionMap = new HashMap();

    public Node createNode(T data) {
        Node ret = new Node(data, this.idIndex);
        this.nodes.put(this.idIndex, ret);
        this.connectionMap.put(this.idIndex, new ArrayList());
        ++this.idIndex;
        return ret;
    }

    public List<Node> getConnectedNodes(Node node) {
        ArrayList<Node> connected = new ArrayList<Node>();
        for (Integer a : this.connectionMap.get(node.id)) {
            connected.add(this.nodes.get(a));
        }
        return connected;
    }

    public Collection<Node> getAllNodes() {
        return this.nodes.values();
    }

    public void connectNodes(Node nodeA, Node nodeB) {
        ArrayList<Integer> newNodeAData = this.connectionMap.get(nodeA.id);
        newNodeAData.add(nodeB.id);
        this.connectionMap.put(nodeA.id, newNodeAData);
        ArrayList<Integer> newNodeBData = this.connectionMap.get(nodeB.id);
        newNodeBData.add(nodeA.id);
        this.connectionMap.put(nodeB.id, newNodeBData);
    }

    public class Node {
        private final int id;
        private final T data;

        private Node(T data, int id) {
            this.data = data;
            this.id = id;
        }

        public T getData() {
            return this.data;
        }
    }
}

