/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.util;

import java.security.InvalidParameterException;

public class GearRatioHelper {
    private final double inputRatio;
    private final double outputRatio;

    public GearRatioHelper(double inputRatio, double outputRatio) throws InvalidParameterException {
        if (inputRatio <= 0.0 || outputRatio <= 0.0) {
            throw new InvalidParameterException("Input/output ratios must be greater than 0!");
        }
        this.inputRatio = inputRatio;
        this.outputRatio = outputRatio;
    }

    public GearRatioHelper(double ratioInputToOutput) {
        this(ratioInputToOutput, 1.0);
    }

    public double toDoubleRatioInputToOutput() {
        return this.inputRatio / this.outputRatio;
    }

    public double toDoubleRatioOutputToInput() {
        return this.outputRatio / this.inputRatio;
    }

    public double outputFromInput(double inputSide) {
        return inputSide * this.inputRatio / this.outputRatio;
    }

    public double inputFromOutput(double outputSide) {
        return outputSide * this.outputRatio / this.inputRatio;
    }
}

