/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.trajectory.planning;

import java.util.ArrayList;
import java.util.List;
import org.chsrobotics.lib.math.geometry.Line2D;
import org.chsrobotics.lib.math.geometry.Vector2D;
import org.chsrobotics.lib.trajectory.planning.ConfigurationSpace;

public class LineOfSightPathOptimize {
    public static List<Vector2D> lineOfSightOptimize(ConfigurationSpace environment, List<Vector2D> path) {
        ArrayList<Vector2D> simplifiedList = new ArrayList<Vector2D>();
        Vector2D workingPoint = path.get(0);
        while (!workingPoint.equals(path.get(path.size() - 1))) {
            if (!simplifiedList.contains(workingPoint)) {
                simplifiedList.add(workingPoint);
            }
            Vector2D candidatePoint = workingPoint;
            for (int i = path.indexOf(workingPoint); i < path.size(); ++i) {
                if (!environment.intersectsObstacle(new Line2D(workingPoint, path.get(i)))) {
                    candidatePoint = path.get(i);
                    continue;
                }
                if (i != path.size() - 1) continue;
                return path;
            }
            workingPoint = candidatePoint;
        }
        simplifiedList.add(path.get(path.size() - 1));
        return simplifiedList;
    }
}

