/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.trajectory.planning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.chsrobotics.lib.math.geometry.Vector2D;
import org.chsrobotics.lib.trajectory.planning.CostFunction;
import org.chsrobotics.lib.util.NodeGraph;

public class Dijkstra {
    public static <T> List<T> generatePath(NodeGraph<T> nodes, NodeGraph.Node source, NodeGraph.Node target, CostFunction<T> costFunction) {
        NodeGraph.Node currentNode;
        HashMap<NodeGraph.Node, NodeGraph.Node> closedNodes = new HashMap<NodeGraph.Node, NodeGraph.Node>();
        HashMap<NodeGraph.Node, Double> costs = new HashMap<NodeGraph.Node, Double>();
        ArrayList<NodeGraph.Node> openNodes = new ArrayList<NodeGraph.Node>();
        for (NodeGraph.Node node : nodes.getAllNodes()) {
            closedNodes.put(node, null);
            costs.put(node, Double.POSITIVE_INFINITY);
            openNodes.add(node);
        }
        openNodes.add(source);
        openNodes.add(target);
        closedNodes.put(source, null);
        costs.put(source, 0.0);
        costs.put(target, Double.POSITIVE_INFINITY);
        while (openNodes.size() > 0) {
            currentNode = (NodeGraph.Node)openNodes.get(0);
            for (NodeGraph.Node testNode : openNodes) {
                if (!((Double)costs.get(testNode) < (Double)costs.get(currentNode))) continue;
                currentNode = testNode;
            }
            if (currentNode.equals(target)) break;
            openNodes.remove(currentNode);
            for (NodeGraph.Node neighbor : nodes.getConnectedNodes(currentNode)) {
                double altCost;
                if (!openNodes.contains(neighbor) || !((altCost = (Double)costs.get(currentNode) + costFunction.evaluate(currentNode.getData(), neighbor.getData())) < (Double)costs.get(neighbor))) continue;
                costs.put(neighbor, altCost);
                closedNodes.put(neighbor, currentNode);
            }
        }
        currentNode = target;
        ArrayList arrayList = new ArrayList();
        while (currentNode != null) {
            arrayList.add(0, currentNode.getData());
            currentNode = (NodeGraph.Node)closedNodes.get(currentNode);
        }
        return arrayList;
    }

    public static List<Vector2D> generateSpatialPath(NodeGraph<Vector2D> nodes, NodeGraph.Node source, NodeGraph.Node target) {
        return Dijkstra.generatePath(nodes, source, target, new VectorCostFunction());
    }

    public static <T> double getTotalCost(List<T> path, CostFunction<T> costFunction) {
        double cost = 0.0;
        for (int i = 1; i < path.size(); ++i) {
            cost += costFunction.evaluate(path.get(i), path.get(i - 1));
        }
        return cost;
    }

    public static double getTotalSpatialCost(List<Vector2D> path) {
        return Dijkstra.getTotalCost(path, new VectorCostFunction());
    }

    private static class VectorCostFunction
    implements CostFunction<Vector2D> {
        private VectorCostFunction() {
        }

        @Override
        public double evaluate(Vector2D valueA, Vector2D valueB) {
            return valueA.subtract(valueB).getMagnitude();
        }
    }
}

