/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.trajectory.planning;

import org.chsrobotics.lib.math.geometry.Line2D;
import org.chsrobotics.lib.math.geometry.Polygon;
import org.chsrobotics.lib.math.geometry.Vector2D;

public class ConfigurationSpace {
    private final ConfigurationSpaceDimension dimensionA;
    private final ConfigurationSpaceDimension dimensionB;
    private final Polygon[] obstacles;

    public ConfigurationSpace(ConfigurationSpaceDimension dimensionA, ConfigurationSpaceDimension dimensionB, Polygon ... obstacles) {
        this.dimensionA = dimensionA;
        this.dimensionB = dimensionB;
        this.obstacles = obstacles;
    }

    public boolean isValidPoint(Vector2D point) {
        boolean inBoundsDimB;
        boolean retVal = true;
        boolean inBoundsDimA = this.dimensionA.wrap || point.getX() <= this.dimensionA.max && point.getX() >= this.dimensionA.min;
        boolean bl = inBoundsDimB = this.dimensionB.wrap || point.getY() <= this.dimensionB.max && point.getY() >= this.dimensionB.min;
        if (inBoundsDimA && inBoundsDimB) {
            for (Polygon poly : this.obstacles) {
                if (!retVal) continue;
                retVal = !poly.pointLiesWithin(point);
            }
        } else {
            retVal = false;
        }
        return retVal;
    }

    public boolean intersectsObstacle(Line2D line) {
        boolean retVal = false;
        for (Polygon poly : this.obstacles) {
            if (retVal) continue;
            retVal = poly.lineIntersectsAnyEdge(line);
        }
        return retVal || !this.isValidPoint(line.getStartPoint()) || !this.isValidPoint(line.getEndPoint());
    }

    public Vector2D randomValidPoint() {
        double dimB;
        double dimA = Math.abs(this.dimensionA.max - this.dimensionA.min) * Math.random() + this.dimensionA.min;
        Vector2D vec = new Vector2D(dimA, dimB = Math.abs(this.dimensionB.max - this.dimensionB.min) * Math.random() + this.dimensionB.min);
        if (this.isValidPoint(vec)) {
            return vec;
        }
        return this.randomValidPoint();
    }

    public static class ConfigurationSpaceDimension {
        public final double min;
        public final double max;
        public final boolean wrap;

        public ConfigurationSpaceDimension(double min, double max, boolean wrap) {
            this.min = min;
            this.max = max;
            this.wrap = wrap;
        }
    }
}

