/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.trajectory.motionProfile;

import java.util.Objects;

public class ProfilePhase {
    public final double time;
    public final double position;
    public final double acceleration;
    public final double initialVelocity;

    public ProfilePhase(double acceleration, double initialVelocity, double time) {
        double displacement = 0.5 * acceleration * (time * time) + time * initialVelocity;
        this.time = time;
        this.position = displacement;
        this.acceleration = acceleration;
        this.initialVelocity = initialVelocity;
    }

    protected ProfilePhase(double time, double position, double acceleration, double initialVelocity) {
        this.time = time;
        this.position = position;
        this.acceleration = acceleration;
        this.initialVelocity = initialVelocity;
    }

    public boolean equals(Object other) {
        double epsilon = 1.0E-4;
        if (other instanceof ProfilePhase) {
            ProfilePhase rhs = (ProfilePhase)other;
            return this.time == rhs.time && Math.abs(this.position - rhs.position) < epsilon && Math.abs(this.acceleration - rhs.acceleration) < epsilon && Math.abs(this.initialVelocity - rhs.initialVelocity) < epsilon;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.time, this.position, this.acceleration, this.initialVelocity);
    }

    public String toString() {
        return "Phase[time: " + this.time + ", position: " + this.position + ", acceleration: " + this.acceleration + ", initialVelocity:" + this.initialVelocity + "]";
    }
}

