/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.trajectory.motionProfile;

import java.util.Objects;
import org.chsrobotics.lib.trajectory.motionProfile.MotionProfile;
import org.chsrobotics.lib.trajectory.motionProfile.ProfilePhase;

public class AsymmetricTrapezoidProfile
extends MotionProfile {
    public AsymmetricTrapezoidProfile(Constraints constraints, MotionProfile.State target) {
        this(constraints, target, new MotionProfile.State(0.0, 0.0));
    }

    public AsymmetricTrapezoidProfile(Constraints constraints, MotionProfile.State target, MotionProfile.State initial) {
        super(initial);
        double targetPosition = target.position - initial.position;
        int direction = targetPosition < 0.0 ? -1 : 1;
        double maxVelocity = constraints.maxVelocity * (double)direction;
        double maxAccel = Math.abs(constraints.maxAcceleration) * (double)direction;
        double maxDecel = Math.abs(constraints.maxDeceleration) * (double)direction * -1.0;
        double initialVelocity = direction == 1 ? Math.min(initial.velocity, maxVelocity) : Math.max(initial.velocity, maxVelocity);
        double targetVelocity = direction == 1 ? Math.min(target.velocity, maxVelocity) : Math.max(target.velocity, maxVelocity);
        this.initialState = new MotionProfile.State(initial.position, initialVelocity);
        double accelTime = (maxVelocity - initialVelocity) / maxAccel;
        double accelPos = 0.5 * maxAccel * Math.pow(accelTime, 2.0) + accelTime * initialVelocity;
        double decelTime = (targetVelocity - maxVelocity) / maxDecel;
        double decelPos = -0.5 * maxDecel * Math.pow(decelTime, 2.0) + decelTime * initialVelocity;
        double coastPos = targetPosition - (accelPos + decelPos);
        double coastTime = coastPos / maxVelocity;
        if (coastPos * (double)direction < 0.0) {
            double vDiff = initialVelocity - targetVelocity;
            double a = 0.5 * maxAccel - Math.pow(maxAccel, 2.0) / (2.0 * maxDecel);
            double b = initialVelocity - initialVelocity * maxAccel / maxDecel;
            double c = -(Math.pow(vDiff, 2.0) / (2.0 * maxDecel) + targetVelocity * vDiff / maxDecel + targetPosition);
            accelTime = (-b + (double)direction * Math.sqrt(Math.pow(b, 2.0) - 4.0 * a * c)) / (2.0 * a);
            decelTime = -(maxAccel / maxDecel * accelTime + vDiff / maxDecel);
            accelPos = 0.5 * maxAccel * Math.pow(accelTime, 2.0) + accelTime * initialVelocity;
            decelPos = -0.5 * maxDecel * Math.pow(decelTime, 2.0) + decelTime * targetVelocity;
            coastTime = 0.0;
            coastPos = 0.0;
            if (decelTime < 0.0) {
                accelPos = targetPosition;
                accelTime = (-initialVelocity + Math.sqrt(Math.pow(initialVelocity, 2.0) + 2.0 * maxAccel * accelPos)) / maxAccel;
            }
            if (accelTime < 0.0) {
                decelPos = targetPosition;
                decelTime = 2.0 * decelPos / (initialVelocity + targetVelocity);
                maxDecel = (targetVelocity - initialVelocity) / decelTime;
                accelTime = -1.0;
                maxAccel = 0.0;
            }
        }
        ProfilePhase accelPhase = new ProfilePhase(accelTime, accelPos, maxAccel, initialVelocity);
        ProfilePhase coastPhase = new ProfilePhase(coastTime, coastPos, 0.0, maxVelocity);
        ProfilePhase decelPhase = new ProfilePhase(decelTime, decelPos, maxDecel, accelTime * maxAccel + initialVelocity);
        if (accelPhase.time > 0.0) {
            this.phases.add(accelPhase);
        }
        if (coastPhase.time > 0.0) {
            this.phases.add(coastPhase);
        }
        if (decelPhase.time > 0.0) {
            this.phases.add(decelPhase);
        }
    }

    public static class Constraints {
        public final double maxVelocity;
        public final double maxAcceleration;
        public final double maxDeceleration;

        public Constraints(double maxVelocity, double maxAcceleration, double maxDeceleration) {
            this.maxVelocity = maxVelocity;
            this.maxAcceleration = maxAcceleration;
            this.maxDeceleration = maxDeceleration;
        }

        public boolean equals(Object other) {
            double epsilon = 1.0E-4;
            if (other instanceof Constraints) {
                Constraints rhs = (Constraints)other;
                return Math.abs(this.maxVelocity - rhs.maxVelocity) < epsilon && Math.abs(this.maxAcceleration - rhs.maxAcceleration) < epsilon && Math.abs(this.maxDeceleration - rhs.maxDeceleration) < epsilon;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.maxVelocity, this.maxAcceleration, this.maxDeceleration);
        }

        public String toString() {
            return "AsymmetricTrapezoidProfileConstraints[maxVelocity: " + this.maxVelocity + ", maxAcceleration: " + this.maxAcceleration + ", maxDeceleration" + this.maxDeceleration + "]";
        }
    }
}

