/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.telemetry;

import edu.wpi.first.networktables.NTSendable;
import edu.wpi.first.networktables.NTSendableBuilder;
import edu.wpi.first.networktables.NetworkTableEntry;
import edu.wpi.first.util.sendable.Sendable;
import edu.wpi.first.util.sendable.SendableRegistry;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.chsrobotics.lib.telemetry.HighLevelLogger;
import org.chsrobotics.lib.telemetry.Logger;

public class DashboardChooser<T>
implements NTSendable,
AutoCloseable {
    private static final AtomicInteger numInstances = new AtomicInteger();
    private final int channel;
    private final Map<String, T> optionMap;
    private final String defaultOption;
    private String selectedOption;
    private final Set<ValueUpdater<T>> listeners = new LinkedHashSet<ValueUpdater<T>>();
    private final Set<NetworkTableEntry> activeEntries = new LinkedHashSet<NetworkTableEntry>();
    private final ReentrantLock mutex = new ReentrantLock();
    private Logger<T> logger;
    private final boolean logChanges;

    public static <T> DashboardChooser<T> fromEnum(Class<? extends Option> enumClass, Option defaultOption, boolean logChanges) {
        HashMap<String, Option> options = new HashMap<String, Option>();
        for (Option entry : enumClass.getEnumConstants()) {
            options.put(entry.getDisplayName(), entry);
        }
        options.put(defaultOption.getDisplayName(), defaultOption);
        return new DashboardChooser(options, defaultOption.getDisplayName(), logChanges);
    }

    public static <T> DashboardChooser<T> fromEnum(Class<? extends Option> enumClass, Option defaultOption) {
        return DashboardChooser.fromEnum(enumClass, defaultOption, true);
    }

    public DashboardChooser(Map<String, T> options, String defaultOption, boolean logChanges) {
        if (defaultOption != null && !options.containsKey(defaultOption)) {
            throw new InvalidParameterException("defaultOption must be either null or a valid option value");
        }
        this.channel = numInstances.getAndIncrement();
        if (logChanges) {
            this.logger = new Logger(HighLevelLogger.getInstance().getLog(), "DashboardChooser" + this.channel, "DashboardChooser", false, true);
        }
        this.logChanges = logChanges;
        SendableRegistry.add((Sendable)this, (String)"DashboardChooser", (int)this.channel);
        this.optionMap = options;
        this.defaultOption = defaultOption;
    }

    public DashboardChooser(Map<String, T> options, String defaultOption) {
        this(options, defaultOption, true);
    }

    @Override
    public void close() {
        SendableRegistry.remove((Sendable)this);
    }

    public T getSelected() {
        this.mutex.lock();
        try {
            if (this.selectedOption == null) {
                T t = this.optionMap.get(this.defaultOption);
                return t;
            }
            T t = this.optionMap.get(this.selectedOption);
            return t;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void initSendable(NTSendableBuilder builder) {
        builder.setSmartDashboardType("String Chooser");
        builder.getTable().getEntry(".instance").setDouble((double)this.channel);
        builder.addStringProperty("default", () -> this.defaultOption, null);
        builder.addStringArrayProperty("options", () -> this.optionMap.keySet().toArray(new String[0]), null);
        builder.addStringProperty("active", () -> {
            this.mutex.lock();
            try {
                String string = this.selectedOption == null ? this.defaultOption : this.selectedOption;
                return string;
            }
            finally {
                this.mutex.unlock();
            }
        }, null);
        this.mutex.lock();
        try {
            this.activeEntries.add(builder.getTable().getEntry("active"));
        }
        finally {
            this.mutex.unlock();
        }
        builder.addStringProperty("selected", null, this::onOptionUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOptionUpdate(String option) {
        T oldOption = this.getSelected();
        this.mutex.lock();
        try {
            this.selectedOption = option;
            for (NetworkTableEntry entry : this.activeEntries) {
                entry.setString(option);
            }
        }
        finally {
            this.mutex.unlock();
        }
        T newOption = this.getSelected();
        if (this.logChanges) {
            this.logger.update(newOption);
        }
        for (ValueUpdater<T> listener : this.listeners) {
            listener.onOptionSelected(oldOption, newOption);
        }
    }

    public void registerListener(ValueUpdater<T> updater) {
        this.listeners.add(updater);
    }

    public void unregisterListener(ValueUpdater<T> updater) {
        this.listeners.remove(updater);
    }

    public static interface Option {
        default public String getDisplayName() {
            return this.toString();
        }
    }

    public static interface ValueUpdater<T> {
        public void onOptionSelected(T var1, T var2);
    }
}

