/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.models;

import edu.wpi.first.math.Matrix;
import edu.wpi.first.math.Nat;
import edu.wpi.first.math.VecBuilder;
import edu.wpi.first.math.Vector;
import edu.wpi.first.math.numbers.N1;
import edu.wpi.first.math.numbers.N2;
import edu.wpi.first.math.numbers.N4;
import edu.wpi.first.math.system.NumericalIntegration;
import edu.wpi.first.math.system.plant.DCMotor;
import org.chsrobotics.lib.math.UtilityMath;

public class DoubleJointedArmModel {
    private final double localMass;
    private final double localCGRadius;
    private final double localMoment;
    private final double localLength;
    private final DCMotor localDrive;
    private final double distalMass;
    private final double distalCGRadius;
    private final double distalMoment;
    private final DCMotor distalDrive;
    private final double kG;

    public DoubleJointedArmModel(double localMass, double localCGRadius, double localMoment, double localLength, DCMotor localDrive, double distalMass, double distalCGRadius, double distalMoment, DCMotor distalDrive, double kG) {
        this.localMass = localMass;
        this.localCGRadius = localCGRadius;
        this.localMoment = localMoment;
        this.localLength = localLength;
        this.localDrive = localDrive;
        this.distalMass = distalMass;
        this.distalCGRadius = distalCGRadius;
        this.distalMoment = distalMoment;
        this.distalDrive = distalDrive;
        this.kG = kG;
    }

    public Vector<N2> feedforward(Vector<N2> position, Vector<N2> velocity, Vector<N2> acceleration) {
        Matrix torque = this.inertiaMatrix(position).times(acceleration).plus(this.cMatrix(position, velocity).times(velocity)).plus(this.gravityMatrix(position));
        return VecBuilder.fill((double)this.localDrive.getVoltage(torque.get(0, 0), velocity.get(0, 0)), (double)this.distalDrive.getVoltage(torque.get(1, 0), velocity.get(1, 0)));
    }

    public Vector<N2> feedforward(Vector<N2> position, Vector<N2> velocity) {
        return this.feedforward(position, velocity, (Vector<N2>)VecBuilder.fill((double)0.0, (double)0.0));
    }

    public Vector<N2> feedforward(Vector<N2> position) {
        return this.feedforward(position, (Vector<N2>)VecBuilder.fill((double)0.0, (double)0.0));
    }

    public Matrix<N2, N2> simulate(Matrix<N2, N2> state, Vector<N2> voltages, double dtSeconds) {
        Vector stateAsVector = VecBuilder.fill((double)state.get(0, 0), (double)state.get(0, 1), (double)state.get(1, 0), (double)state.get(1, 1));
        Vector clampedVoltage = VecBuilder.fill((double)UtilityMath.clamp(this.localDrive.nominalVoltageVolts, voltages.get(0, 0)), (double)UtilityMath.clamp(this.distalDrive.nominalVoltageVolts, voltages.get(1, 0)));
        Matrix prelim = NumericalIntegration.rkdp(this::instDynamics, (Matrix)stateAsVector, (Matrix)clampedVoltage, (double)dtSeconds);
        Matrix mat = new Matrix((Nat)N2.instance, (Nat)N2.instance);
        mat.set(0, 0, prelim.get(0, 0));
        mat.set(0, 1, prelim.get(1, 0));
        mat.set(1, 0, prelim.get(2, 0));
        mat.set(1, 1, prelim.get(3, 0));
        return mat;
    }

    private Matrix<N4, N1> instDynamics(Matrix<N4, N1> x, Matrix<N2, N1> u) {
        Matrix mat = new Matrix((Nat)N4.instance, (Nat)N1.instance);
        Vector positions = VecBuilder.fill((double)x.get(0, 0), (double)x.get(1, 0));
        Vector velocities = VecBuilder.fill((double)x.get(2, 0), (double)x.get(3, 0));
        Vector torques = VecBuilder.fill((double)this.localDrive.getTorque(this.localDrive.getCurrent(velocities.get(0, 0), u.get(0, 0))), (double)this.distalDrive.getTorque(this.distalDrive.getCurrent(velocities.get(1, 0), u.get(1, 0))));
        Matrix accel = this.inertiaMatrix((Vector<N2>)positions).inv().times(torques.minus(this.cMatrix((Vector<N2>)positions, (Vector<N2>)velocities).times((Matrix)velocities)).minus(this.gravityMatrix((Vector<N2>)positions)));
        mat.set(0, 0, velocities.get(0, 0));
        mat.set(1, 0, velocities.get(1, 0));
        mat.set(2, 0, accel.get(0, 0));
        mat.set(3, 0, accel.get(1, 0));
        return mat;
    }

    private Matrix<N2, N2> inertiaMatrix(Vector<N2> position) {
        Matrix mat = new Matrix((Nat)N2.instance, (Nat)N2.instance);
        mat.set(0, 0, this.localMass * this.localCGRadius * this.localCGRadius + this.distalMass * (Math.pow(this.localLength, 2.0) + Math.pow(this.distalCGRadius, 2.0)) + this.localMoment + this.distalMoment + 2.0 * this.distalMass * this.localLength * this.distalCGRadius * Math.cos(position.get(1, 0)));
        mat.set(1, 0, this.distalMass * this.distalCGRadius * this.distalCGRadius + this.distalMoment + this.distalMass * this.localLength * this.distalCGRadius * Math.cos(position.get(1, 0)));
        mat.set(0, 1, this.distalMass * this.distalCGRadius * this.distalCGRadius + this.distalMoment + this.distalMass * this.distalCGRadius * Math.cos(position.get(1, 0)));
        mat.set(1, 1, this.distalMass * this.distalCGRadius * this.distalCGRadius + this.distalMoment);
        return mat;
    }

    private Matrix<N2, N2> cMatrix(Vector<N2> positions, Vector<N2> velocities) {
        Matrix mat = new Matrix((Nat)N2.instance, (Nat)N2.instance);
        mat.set(0, 0, -this.distalMass * this.localLength * this.distalCGRadius * velocities.get(1, 0));
        mat.set(0, 1, -this.distalMass * this.localLength * this.distalCGRadius * Math.sin(positions.get(1, 0)) * (velocities.get(0, 0) + velocities.get(1, 0)));
        mat.set(1, 0, this.distalMass * this.localLength * this.distalCGRadius * Math.sin(positions.get(1, 0)) * velocities.get(1, 0));
        mat.set(1, 1, 0.0);
        return mat;
    }

    private Matrix<N2, N1> gravityMatrix(Vector<N2> positions) {
        Matrix mat = new Matrix((Nat)N2.instance, (Nat)N1.instance);
        double g = 98.10000000000001;
        mat.set(0, 0, g * (Math.cos(positions.get(0, 0)) * (this.localMass * this.localCGRadius + (this.distalMass + this.distalCGRadius)) + this.distalMass * this.distalCGRadius * Math.cos(positions.get(0, 0) + positions.get(1, 0))));
        mat.set(1, 0, g * this.distalMass * this.distalCGRadius * Math.cos(positions.get(0, 0) + positions.get(1, 0)));
        return mat.times(this.kG);
    }
}

