/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.models;

import org.chsrobotics.lib.util.Tuple2;

public class DoubleJointedArmKinematics {
    public final double localLength;
    public final double distalLength;

    public DoubleJointedArmKinematics(double localLength, double distalLength) {
        this.localLength = localLength;
        this.distalLength = distalLength;
    }

    public RRConfiguration forwardKinematics(double localAngle, double distalAngle) {
        if (this.localLength <= 0.0 || this.distalLength <= 0.0) {
            return null;
        }
        double endEffectorAngle = localAngle + distalAngle;
        double x = this.localLength * Math.cos(localAngle) + this.distalLength * Math.cos(endEffectorAngle);
        double y = this.localLength * Math.sin(localAngle) + this.distalLength * Math.sin(endEffectorAngle);
        return new RRConfiguration(localAngle, distalAngle, endEffectorAngle, x, y);
    }

    public Tuple2<RRConfiguration> inverseKinematics(double endEffectorX, double endEffectorY) {
        RRConfiguration righty;
        RRConfiguration lefty;
        if (this.localLength <= 0.0 || this.distalLength <= 0.0 || endEffectorX == 0.0 && endEffectorY == 0.0) {
            return Tuple2.of(null, null);
        }
        double rootToEffectorVectorDirection = Math.atan2(endEffectorY, endEffectorX);
        double cosAlpha = (Math.pow(endEffectorX, 2.0) + Math.pow(endEffectorY, 2.0) + Math.pow(this.localLength, 2.0) - Math.pow(this.distalLength, 2.0)) / (2.0 * this.localLength * Math.pow(Math.pow(endEffectorX, 2.0) + Math.pow(endEffectorY, 2.0), 0.5));
        double cosBeta = (Math.pow(this.localLength, 2.0) + Math.pow(this.distalLength, 2.0) - Math.pow(endEffectorX, 2.0) - Math.pow(endEffectorY, 2.0)) / (2.0 * this.localLength * this.distalLength);
        if (cosAlpha < -1.0 || cosAlpha > 1.0 || cosBeta < -1.0 || cosBeta > 1.0) {
            lefty = null;
            righty = null;
        } else {
            double thetaARighty = rootToEffectorVectorDirection - Math.acos(cosAlpha);
            double thetaBRighty = Math.PI - Math.acos(cosBeta);
            double thetaALefty = rootToEffectorVectorDirection + Math.acos(cosAlpha);
            double thetaBLefty = Math.acos(cosBeta) - Math.PI;
            righty = new RRConfiguration(thetaARighty, thetaBRighty, thetaARighty + thetaBRighty, endEffectorX, endEffectorY);
            lefty = new RRConfiguration(thetaALefty, thetaBLefty, thetaALefty + thetaBLefty, endEffectorX, endEffectorY);
        }
        return Tuple2.of(righty, lefty);
    }

    public static class RRConfiguration {
        public final double localAngle;
        public final double distalAngle;
        public final double endEffectorAngle;
        public final double endEffectorX;
        public final double endEffectorY;

        public RRConfiguration(double localAngle, double distalAngle, double endEffectorAngle, double endEffectorX, double endEffectorY) {
            this.localAngle = localAngle;
            this.distalAngle = distalAngle;
            this.endEffectorAngle = endEffectorAngle;
            this.endEffectorX = endEffectorX;
            this.endEffectorY = endEffectorY;
        }

        public String toString() {
            return "Double Jointed Arm Configuration: localAngle: " + this.localAngle + ", distalAngle: " + this.distalAngle + ", endEffectorAngle: " + this.endEffectorAngle + ", endEffectorX: " + this.endEffectorX + ", endEffectorY: " + this.endEffectorY;
        }

        public boolean equals(Object other) {
            if (other instanceof RRConfiguration) {
                RRConfiguration rhs = (RRConfiguration)other;
                return rhs.localAngle == this.localAngle && rhs.distalAngle == this.distalAngle && rhs.endEffectorAngle == this.endEffectorAngle && rhs.endEffectorX == this.endEffectorX && rhs.endEffectorY == this.endEffectorY;
            }
            return false;
        }
    }
}

