/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.geometry;

import java.util.ArrayList;
import org.chsrobotics.lib.math.geometry.Line2D;
import org.chsrobotics.lib.math.geometry.Vector2D;

public class Polygon {
    private final ArrayList<Line2D> sides = new ArrayList();

    public Polygon(Vector2D ... vertices) {
        for (int i = 0; i < vertices.length - 1; ++i) {
            this.sides.add(new Line2D(vertices[i], vertices[i + 1]));
        }
        this.sides.add(new Line2D(vertices[vertices.length - 1], vertices[0]));
    }

    public boolean lineIntersectsAnyEdge(Line2D line) {
        boolean retVal = false;
        for (Line2D edge : this.sides) {
            if (retVal) continue;
            retVal = edge.intersects(line);
        }
        return retVal;
    }

    public boolean pointLiesWithin(Vector2D point) {
        for (Line2D side : this.sides) {
            if (!side.pointOn(point)) continue;
            return true;
        }
        Line2D projection = new Line2D(point, new Vector2D(point.getX() + 2.147483647E9, point.getY()));
        int intersectionCounter = 0;
        for (Line2D side : this.sides) {
            if (!side.intersects(projection) || side.getDirectionRadians() == Math.PI || side.getDirectionRadians() == 0.0) continue;
            ++intersectionCounter;
        }
        return intersectionCounter % 2 == 1;
    }

    public static Polygon getRectangle(Vector2D root, double length, double height) {
        return new Polygon(root, new Vector2D(root.getX() + length, root.getY()), new Vector2D(root.getX() + length, root.getY() + height), new Vector2D(root.getX(), root.getY() + height));
    }
}

