/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.geometry;

import edu.wpi.first.math.geometry.Rotation3d;
import edu.wpi.first.math.geometry.Translation3d;
import org.chsrobotics.lib.math.geometry.Vector3D;

public class CardinalSpline {
    private final double tension;
    private final Vector3D[] points;
    private final Rotation3d startAngle;
    private final Rotation3d endAngle;

    public CardinalSpline(double tension, Rotation3d startAngle, Rotation3d endAngle, Vector3D ... points) {
        this.tension = tension;
        this.points = points;
        this.startAngle = startAngle;
        this.endAngle = endAngle;
    }

    public Vector3D sample(double reference) {
        Vector3D endTan;
        Translation3d rotated;
        Vector3D startTan;
        if (reference < 0.0 || reference > (double)(this.points.length - 1)) {
            return null;
        }
        Vector3D hermiteStart = this.points[(int)reference];
        Vector3D hermiteEnd = this.points[(int)reference + 1];
        if (reference > 1.0) {
            startTan = hermiteEnd.subtract(this.points[(int)reference - 1]).scalarMultiply(this.tension);
        } else {
            rotated = new Translation3d(1.0, 0.0, 0.0).rotateBy(this.startAngle);
            startTan = new Vector3D(rotated.getX(), rotated.getY(), rotated.getZ());
        }
        if (reference < (double)(this.points.length - 2)) {
            endTan = this.points[(int)reference + 2].subtract(hermiteStart).scalarMultiply(this.tension);
        } else {
            rotated = new Translation3d(1.0, 0.0, 0.0).rotateBy(this.endAngle);
            endTan = new Vector3D(rotated.getX(), rotated.getY(), rotated.getZ());
        }
        double localReference = reference - (double)((int)reference);
        Vector3D startControlPoint = this.points[(int)reference];
        Vector3D endControlPoint = this.points[(int)reference + 1];
        Vector3D h00 = startControlPoint.scalarMultiply(2.0 * Math.pow(localReference, 3.0) - 3.0 * Math.pow(localReference, 2.0) + 1.0);
        Vector3D h10 = startTan.scalarMultiply(Math.pow(localReference, 3.0) - 2.0 * Math.pow(localReference, 2.0) + localReference);
        Vector3D h11 = endControlPoint.scalarMultiply(-2.0 * Math.pow(localReference, 3.0) + 3.0 * Math.pow(localReference, 2.0));
        Vector3D h01 = endTan.scalarMultiply(Math.pow(localReference, 3.0) - Math.pow(localReference, 2.0));
        return h00.add(h10).add(h11).add(h01);
    }
}

