/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

import org.chsrobotics.lib.math.filters.Filter;

public class ExponentialMovingAverage
extends Filter {
    private final double responseConstant;
    private double lastOutput = 0.0;

    public ExponentialMovingAverage(double responseConstant) {
        this.responseConstant = responseConstant;
    }

    @Override
    public double calculate(double value) {
        this.lastOutput = value * this.responseConstant + (1.0 - this.responseConstant) * this.lastOutput;
        return this.lastOutput;
    }

    @Override
    public double calculate(double value, double dtSeconds) {
        return this.calculate(value);
    }

    @Override
    public void reset() {
        this.lastOutput = 0.0;
    }

    @Override
    public double getCurrentOutput() {
        return this.lastOutput;
    }
}

