/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

import org.chsrobotics.lib.math.filters.Filter;

public class ComposedFilter
extends Filter {
    private final Filter[] filters;
    private double currentOuput = 0.0;

    public ComposedFilter(Filter ... filters) {
        this.filters = filters;
    }

    @Override
    public double calculate(double value) {
        double lastValue = value;
        for (Filter filter : this.filters) {
            lastValue = filter.calculate(lastValue);
        }
        this.currentOuput = lastValue;
        return this.currentOuput;
    }

    @Override
    public double calculate(double value, double dtSeconds) {
        double lastValue = value;
        for (Filter filter : this.filters) {
            lastValue = filter.calculate(lastValue, dtSeconds);
        }
        this.currentOuput = lastValue;
        return this.currentOuput;
    }

    @Override
    public void reset() {
        for (Filter filter : this.filters) {
            filter.reset();
        }
    }

    @Override
    public double getCurrentOutput() {
        return this.currentOuput;
    }
}

