/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.input;

import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.event.EventLoop;
import edu.wpi.first.wpilibj2.command.CommandScheduler;
import java.util.HashMap;
import java.util.Map;
import org.chsrobotics.lib.input.JoystickAxis;
import org.chsrobotics.lib.input.JoystickButton;
import org.chsrobotics.lib.telemetry.HighLevelLogger;

public class XboxController {
    private final GenericHID controller;
    private double rightRumble = 0.0;
    private double leftRumble = 0.0;
    private final HashMap<Integer, Boolean> axisAllocations = new HashMap(Map.ofEntries(Map.entry(0, false), Map.entry(1, false), Map.entry(2, false), Map.entry(3, false), Map.entry(4, false), Map.entry(5, false)));
    private final HashMap<Integer, Boolean> buttonAllocations = new HashMap(Map.ofEntries(Map.entry(1, false), Map.entry(2, false), Map.entry(3, false), Map.entry(4, false), Map.entry(5, false), Map.entry(6, false), Map.entry(7, false), Map.entry(8, false), Map.entry(9, false), Map.entry(10, false)));
    private final EventLoop pollingLoop;

    public XboxController(EventLoop pollingLoop, int port) {
        this.controller = new GenericHID(port);
        this.pollingLoop = pollingLoop;
    }

    public XboxController(int port) {
        this(CommandScheduler.getInstance().getDefaultButtonLoop(), port);
    }

    public void setRightRumble(double value) {
        this.controller.setRumble(GenericHID.RumbleType.kRightRumble, value);
        this.rightRumble = value;
    }

    public void setLeftRumble(double value) {
        this.controller.setRumble(GenericHID.RumbleType.kLeftRumble, value);
        this.leftRumble = value;
    }

    public double getRightRumble() {
        return this.rightRumble;
    }

    public double getLeftRumble() {
        return this.leftRumble;
    }

    public JoystickAxis leftStickVerticalAxis() {
        return this.getJoystickAxis(1);
    }

    public JoystickAxis leftStickHorizontalAxis() {
        return this.getJoystickAxis(0);
    }

    public JoystickAxis rightStickVerticalAxis() {
        return this.getJoystickAxis(5);
    }

    public JoystickAxis rightStickHorizontalAxis() {
        return this.getJoystickAxis(4);
    }

    public JoystickAxis leftTriggerAxis() {
        return this.getJoystickAxis(2);
    }

    public JoystickAxis rightTriggerAxis() {
        return this.getJoystickAxis(3);
    }

    public JoystickButton AButton() {
        return this.getJoystickButton(1);
    }

    public JoystickButton BButton() {
        return this.getJoystickButton(2);
    }

    public JoystickButton XButton() {
        return this.getJoystickButton(3);
    }

    public JoystickButton YButton() {
        return this.getJoystickButton(4);
    }

    public JoystickButton leftBumperButton() {
        return this.getJoystickButton(5);
    }

    public JoystickButton rightBumperButton() {
        return this.getJoystickButton(6);
    }

    public JoystickButton leftStickButton() {
        return this.getJoystickButton(9);
    }

    public JoystickButton rightStickButton() {
        return this.getJoystickButton(10);
    }

    public JoystickButton backButton() {
        return this.getJoystickButton(7);
    }

    public JoystickButton startButton() {
        return this.getJoystickButton(8);
    }

    private JoystickButton getJoystickButton(int index) {
        if (this.buttonAllocations.get(index).booleanValue()) {
            HighLevelLogger.getInstance().logWarning("Joystick button at port " + index + " already allocated!");
        } else {
            this.buttonAllocations.replace(index, true);
        }
        return new JoystickButton(this.pollingLoop, () -> this.controller.getRawButton(index), Integer.toString(index), true);
    }

    private JoystickAxis getJoystickAxis(int index) {
        if (this.axisAllocations.get(index).booleanValue()) {
            HighLevelLogger.getInstance().logWarning("Joystick axis at port " + index + " already allocated!");
        } else {
            this.axisAllocations.replace(index, true);
        }
        return new JoystickAxis(() -> this.controller.getRawAxis(index), Integer.toString(index), true);
    }
}

