/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.hardware.ledStrip;

import org.chsrobotics.lib.hardware.ledStrip.LEDAnimation;
import org.chsrobotics.lib.hardware.ledStrip.LEDAnimationFrame;
import org.chsrobotics.lib.hardware.ledStrip.RGBColor;

public class SimpleLEDAnimation
implements LEDAnimation {
    private final LEDAnimationFrame[] frames;
    private final int expectedLength;
    private int animationIndex = 0;

    public SimpleLEDAnimation(LEDAnimationFrame ... frames) {
        this.frames = new LEDAnimationFrame[frames.length];
        if (frames.length > 0) {
            int expectedLength = frames[0].numberOfPixels();
            for (int i = 0; i < frames.length; ++i) {
                this.frames[i] = frames[i].toNewSize(expectedLength);
            }
            this.expectedLength = expectedLength;
        } else {
            this.expectedLength = 0;
        }
    }

    public int numberOfFrames() {
        return this.frames.length;
    }

    @Override
    public int numberOfPixelsPerFrame() {
        return this.expectedLength;
    }

    @Override
    public LEDAnimationFrame getNextFrame() {
        if (this.numberOfFrames() != 0) {
            int preIndex = this.animationIndex;
            this.animationIndex = this.animationIndex == this.numberOfFrames() - 1 ? 0 : ++this.animationIndex;
            return this.getFrame(preIndex).toNewSize(this.expectedLength);
        }
        return new LEDAnimationFrame(new RGBColor[0]);
    }

    public LEDAnimationFrame getFrame(int index) {
        if (this.frames.length == 0) {
            return new LEDAnimationFrame(new RGBColor[0]);
        }
        int pIndex = index >= this.frames.length ? this.frames.length - 1 : (index < 0 ? 0 : index);
        return this.frames[pIndex];
    }

    public static SimpleLEDAnimation gradientCascade(int size, RGBColor colorA, RGBColor colorB) {
        if (size <= 0) {
            return new SimpleLEDAnimation(new LEDAnimationFrame[0]);
        }
        RGBColor[] root = new RGBColor[size];
        for (int i = 0; i < size - 1; ++i) {
            root[i] = colorA.smear((double)i / (double)(size - 1), colorB);
        }
        root[size - 1] = colorB;
        return SimpleLEDAnimation.cascading(new LEDAnimationFrame(root));
    }

    public static SimpleLEDAnimation cascading(LEDAnimationFrame root) {
        if (root.numberOfPixels() == 0) {
            return new SimpleLEDAnimation(new LEDAnimationFrame[0]);
        }
        LEDAnimationFrame[] lFrames = new LEDAnimationFrame[root.numberOfPixels()];
        lFrames[0] = root;
        for (int i = 1; i < root.numberOfPixels(); ++i) {
            lFrames[i] = lFrames[i - 1].offset(1);
        }
        return new SimpleLEDAnimation(lFrames);
    }

    public static SimpleLEDAnimation flashing(int periodCyclesA, int periodCyclesB, LEDAnimationFrame frameA, LEDAnimationFrame frameB) {
        int i;
        if (periodCyclesA <= 0 || periodCyclesB <= 0 || frameA.numberOfPixels() == 0 || frameB.numberOfPixels() == 0) {
            return new SimpleLEDAnimation(new LEDAnimationFrame[0]);
        }
        LEDAnimationFrame[] lFrames = new LEDAnimationFrame[periodCyclesA + periodCyclesB];
        for (i = 0; i < periodCyclesA; ++i) {
            lFrames[i] = frameA;
        }
        for (i = 0; i < periodCyclesB; ++i) {
            lFrames[i + periodCyclesA] = frameB;
        }
        return new SimpleLEDAnimation(lFrames);
    }

    public boolean equals(Object other) {
        if (other instanceof SimpleLEDAnimation) {
            SimpleLEDAnimation rhs = (SimpleLEDAnimation)other;
            if (this.numberOfFrames() == rhs.numberOfFrames()) {
                boolean sameSoFar = true;
                for (int i = 0; i < this.numberOfFrames(); ++i) {
                    if (!sameSoFar) continue;
                    sameSoFar = this.getFrame(i).equals(rhs.getFrame(i));
                }
                return sameSoFar;
            }
            return false;
        }
        return false;
    }
}

