/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.hardware.ledStrip;

public class RGBColor {
    public final int r;
    public final int g;
    public final int b;
    public static final RGBColor RED = new RGBColor(255, 0, 0);
    public static final RGBColor GREEN = new RGBColor(0, 255, 0);
    public static final RGBColor BLUE = new RGBColor(0, 0, 255);
    public static final RGBColor ORANGE = new RGBColor(204, 136, 0);
    public static final RGBColor YELLOW = new RGBColor(255, 255, 0);
    public static final RGBColor INDIGO = new RGBColor(111, 0, 255);
    public static final RGBColor VIOLET = new RGBColor(217, 25, 255);
    public static final RGBColor WHITE = new RGBColor(255, 255, 255);
    public static final RGBColor BLACK = new RGBColor(0, 0, 0);

    public RGBColor(int r, int g, int b) {
        this.r = r > 255 ? 255 : (r < 0 ? 0 : r);
        this.g = g > 255 ? 255 : (g < 0 ? 0 : g);
        this.b = b > 255 ? 255 : (b < 0 ? 0 : b);
    }

    public RGBColor smear(double reference, RGBColor other) {
        double pReference = reference < 0.0 ? 0.0 : (reference > 1.0 ? 1.0 : reference);
        double nR = (double)this.r * (1.0 - pReference) + (double)other.r * pReference;
        double nG = (double)this.g * (1.0 - pReference) + (double)other.g * pReference;
        double nB = (double)this.b * (1.0 - pReference) + (double)other.b * pReference;
        return new RGBColor((int)nR, (int)nG, (int)nB);
    }

    public RGBColor changeSaturation(double proportion) {
        return new RGBColor((int)((double)this.r * proportion), (int)((double)this.g * proportion), (int)((double)this.b * proportion));
    }

    public boolean equals(Object other) {
        if (other instanceof RGBColor) {
            RGBColor rhs = (RGBColor)other;
            return this.r == rhs.r && this.g == rhs.g && this.b == rhs.b;
        }
        return false;
    }

    public String toString() {
        return "RGBColor (" + this.r + "," + this.g + "," + this.b + ")";
    }
}

