/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.hardware.ledStrip;

import edu.wpi.first.wpilibj.AddressableLED;
import edu.wpi.first.wpilibj.AddressableLEDBuffer;
import org.chsrobotics.lib.hardware.ledStrip.LEDAnimation;
import org.chsrobotics.lib.hardware.ledStrip.LEDAnimationFrame;
import org.chsrobotics.lib.hardware.ledStrip.RGBColor;
import org.chsrobotics.lib.hardware.ledStrip.SimpleLEDAnimation;

public class LEDStrip {
    private final AddressableLED leds;
    private final AddressableLEDBuffer buffer;
    private final int length;
    private LEDAnimation animation = new SimpleLEDAnimation(new LEDAnimationFrame[0]);

    public LEDStrip(int PWMChannel, int length) {
        this.leds = new AddressableLED(PWMChannel);
        this.leds.setLength(length);
        this.buffer = new AddressableLEDBuffer(length);
        this.length = length;
    }

    public void setAnimation(LEDAnimation animation) {
        this.animation = animation;
    }

    public void setFrame(LEDAnimationFrame frame) {
        this.animation = new SimpleLEDAnimation(frame);
    }

    public void update() {
        LEDAnimationFrame frame = this.animation.getNextFrame();
        for (int i = 0; i < frame.numberOfPixels(); ++i) {
            if (i >= this.length) continue;
            RGBColor pixel = frame.getPixel(i);
            this.buffer.setRGB(i, pixel.r, pixel.g, pixel.b);
        }
    }
}

