/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.hardware.ledStrip;

import org.chsrobotics.lib.hardware.ledStrip.RGBColor;

public class LEDAnimationFrame {
    private final RGBColor[] pixels;

    public LEDAnimationFrame(RGBColor ... pixelColors) {
        this.pixels = pixelColors;
    }

    public int numberOfPixels() {
        return this.pixels.length;
    }

    public RGBColor getPixel(int index) {
        if (index < 0 || index >= this.pixels.length) {
            return RGBColor.BLACK;
        }
        return this.pixels[index];
    }

    public LEDAnimationFrame toNewSize(int newSize) {
        RGBColor[] output = new RGBColor[newSize];
        if (newSize == this.pixels.length || newSize <= 0 || this.numberOfPixels() == 0) {
            return this;
        }
        if (newSize < this.pixels.length) {
            for (int i = 0; i < newSize; ++i) {
                output[i] = this.pixels[i];
            }
        } else {
            for (int i = 0; i < newSize; ++i) {
                output[i] = this.pixels[i % this.pixels.length];
            }
        }
        return new LEDAnimationFrame(output);
    }

    public LEDAnimationFrame offset(int step) {
        int modStep = step % this.pixels.length;
        RGBColor[] output = new RGBColor[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            int newIndex = i + modStep;
            if (newIndex >= this.pixels.length) {
                newIndex -= this.pixels.length;
            } else if (newIndex < 0) {
                newIndex += this.pixels.length;
            }
            output[newIndex] = this.pixels[i];
        }
        return new LEDAnimationFrame(output);
    }

    public LEDAnimationFrame add(LEDAnimationFrame other) {
        int i;
        RGBColor[] colors = new RGBColor[this.pixels.length + other.pixels.length];
        for (i = 0; i < this.pixels.length; ++i) {
            colors[i] = this.pixels[i];
        }
        for (i = 0; i < other.pixels.length; ++i) {
            colors[i + this.pixels.length] = other.pixels[i];
        }
        return new LEDAnimationFrame(colors);
    }

    public static LEDAnimationFrame alternating(int numberColorA, int numberColorB, RGBColor colorA, RGBColor colorB) {
        int i;
        if (numberColorA <= 0 || numberColorB <= 0) {
            return new LEDAnimationFrame(new RGBColor[0]);
        }
        RGBColor[] colors = new RGBColor[numberColorA + numberColorB];
        for (i = 0; i < numberColorA; ++i) {
            colors[i] = colorA;
        }
        for (i = 0; i < numberColorB; ++i) {
            colors[i + numberColorA] = colorB;
        }
        return new LEDAnimationFrame(colors);
    }

    public boolean equals(Object other) {
        if (other instanceof LEDAnimationFrame) {
            LEDAnimationFrame rhs = (LEDAnimationFrame)other;
            if (this.numberOfPixels() == rhs.numberOfPixels()) {
                boolean sameSoFar = true;
                for (int i = 0; i < this.numberOfPixels(); ++i) {
                    if (!sameSoFar) continue;
                    sameSoFar = this.getPixel(i).equals(rhs.getPixel(i));
                }
                return sameSoFar;
            }
            return false;
        }
        return false;
    }
}

