/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.drive.differential;

import java.util.function.Supplier;
import org.chsrobotics.lib.drive.differential.DifferentialDriveMode;
import org.chsrobotics.lib.drive.differential.DifferentialDrivetrainInput;
import org.chsrobotics.lib.math.filters.RateLimiter;

public class TankDrive
implements DifferentialDriveMode {
    private final Supplier<Double> leftAxis;
    private final Supplier<Double> rightAxis;
    private final Supplier<Double> driveModifier;
    private RateLimiter leftDriveLimiter;
    private RateLimiter rightDriveLimiter;

    public TankDrive(Supplier<Double> leftAxis, Supplier<Double> rightAxis, Supplier<Double> driveModifier, double driveLimiter) {
        this.leftAxis = leftAxis;
        this.rightAxis = rightAxis;
        this.driveModifier = driveModifier;
        this.leftDriveLimiter = new RateLimiter(driveLimiter);
        this.rightDriveLimiter = new RateLimiter(driveLimiter);
    }

    public TankDrive(Supplier<Double> leftAxis, Supplier<Double> rightAxis) {
        this(leftAxis, rightAxis, () -> 1.0, 0.0);
    }

    @Override
    public DifferentialDrivetrainInput execute() {
        double left = this.leftAxis.get() * this.driveModifier.get();
        double right = this.rightAxis.get() * this.driveModifier.get();
        left = this.leftDriveLimiter.calculate(left);
        right = this.rightDriveLimiter.calculate(right);
        return new DifferentialDrivetrainInput(left, right).clamp(1.0);
    }
}

