/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.drive.differential;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.chsrobotics.lib.drive.differential.DifferentialDriveMode;
import org.chsrobotics.lib.drive.differential.DifferentialDrivetrainInput;

public class MixedDrive
implements DifferentialDriveMode {
    final Map<DifferentialDriveMode, Double> driveModes;

    public MixedDrive(Map<DifferentialDriveMode, Double> driveModes) {
        if (driveModes.values().stream().anyMatch(Predicate.isEqual(null))) {
            throw new IllegalArgumentException("DriveMode proportions cannot be null");
        }
        if (!driveModes.values().stream().reduce(Double::sum).equals(Optional.of(1.0))) {
            throw new IllegalArgumentException("DriveMode proportions must add to 1");
        }
        this.driveModes = driveModes;
    }

    @Override
    public DifferentialDrivetrainInput execute() {
        DifferentialDrivetrainInput total = new DifferentialDrivetrainInput(0.0, 0.0);
        for (Map.Entry<DifferentialDriveMode, Double> entry : this.driveModes.entrySet()) {
            total = total.add(entry.getKey().execute().multiply(entry.getValue()));
        }
        return total;
    }
}

