/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.drive.differential;

import edu.wpi.first.math.MathUtil;
import java.util.Objects;

public class DifferentialDrivetrainInput {
    public final double left;
    public final double right;

    public DifferentialDrivetrainInput(double left, double right) {
        this.left = left;
        this.right = right;
    }

    public DifferentialDrivetrainInput multiply(double scalar) {
        return new DifferentialDrivetrainInput(this.left * scalar, this.right * scalar);
    }

    public DifferentialDrivetrainInput add(DifferentialDrivetrainInput other) {
        return new DifferentialDrivetrainInput(this.left + other.left, this.right + other.right);
    }

    public DifferentialDrivetrainInput clamp(double maxAbsValue) {
        if (Math.abs(maxAbsValue) == 0.0) {
            return new DifferentialDrivetrainInput(0.0, 0.0);
        }
        return new DifferentialDrivetrainInput(MathUtil.clamp((double)this.left, (double)(-maxAbsValue), (double)maxAbsValue), MathUtil.clamp((double)this.right, (double)(-maxAbsValue), (double)maxAbsValue));
    }

    public String toString() {
        return "Move[left: " + this.left + ", right: " + this.right + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DifferentialDrivetrainInput that = (DifferentialDrivetrainInput)o;
        return that.left == this.left && that.right == this.right;
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

