/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.drive.differential;

import java.util.function.Supplier;
import org.chsrobotics.lib.drive.differential.DifferentialDriveMode;
import org.chsrobotics.lib.drive.differential.DifferentialDrivetrainInput;
import org.chsrobotics.lib.math.filters.RateLimiter;

public class CurvatureDrive
implements DifferentialDriveMode {
    private final Supplier<Double> linearAxis;
    private final Supplier<Double> rotationalAxis;
    private final Supplier<Double> turnModifier;
    private final Supplier<Double> driveModifier;
    private final RateLimiter driveLimiter;
    private final RateLimiter turnLimiter;
    private final boolean invertReverseTurning;

    public CurvatureDrive(Supplier<Double> linearAxis, Supplier<Double> rotationalAxis, Supplier<Double> driveModifier, Supplier<Double> turnModifier, double driveLimiter, double turnLimiter, boolean invertReverseTurning) {
        this.linearAxis = linearAxis;
        this.rotationalAxis = rotationalAxis;
        this.driveModifier = driveModifier;
        this.turnModifier = turnModifier;
        this.driveLimiter = new RateLimiter(driveLimiter);
        this.turnLimiter = new RateLimiter(turnLimiter);
        this.invertReverseTurning = invertReverseTurning;
    }

    @Override
    public DifferentialDrivetrainInput execute() {
        double rotationMultiplier = this.invertReverseTurning ? Math.abs(this.linearAxis.get()) : this.linearAxis.get();
        double rotation = this.turnLimiter.calculate(this.rotationalAxis.get() * rotationMultiplier * this.turnModifier.get());
        double linear = this.driveLimiter.calculate(this.linearAxis.get() * this.driveModifier.get());
        double left = linear + rotation;
        double right = linear - rotation;
        return new DifferentialDrivetrainInput(left, right).clamp(1.0);
    }
}

