/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.drive.differential;

import java.util.function.Supplier;
import org.chsrobotics.lib.drive.differential.DifferentialDriveMode;
import org.chsrobotics.lib.drive.differential.DifferentialDrivetrainInput;
import org.chsrobotics.lib.math.filters.RateLimiter;

public class ArcadeDrive
implements DifferentialDriveMode {
    private final Supplier<Double> linearAxis;
    private final Supplier<Double> rotationalAxis;
    private final Supplier<Double> driveModifier;
    private final Supplier<Double> turnModifier;
    private final RateLimiter driveLimiter;
    private final RateLimiter turnLimiter;

    public ArcadeDrive(Supplier<Double> linearAxis, Supplier<Double> rotationalAxis, Supplier<Double> driveModifier, Supplier<Double> turnModifier, double driveLimiter, double turnLimiter) {
        this.linearAxis = linearAxis;
        this.rotationalAxis = rotationalAxis;
        this.driveModifier = driveModifier;
        this.turnModifier = turnModifier;
        this.driveLimiter = new RateLimiter(driveLimiter);
        this.turnLimiter = new RateLimiter(turnLimiter);
    }

    @Override
    public DifferentialDrivetrainInput execute() {
        double linear = this.driveLimiter.calculate(this.linearAxis.get() * this.driveModifier.get());
        double rotation = this.turnLimiter.calculate(this.rotationalAxis.get() * this.turnModifier.get());
        double left = linear + rotation;
        double right = linear - rotation;
        return new DifferentialDrivetrainInput(left, right).clamp(1.0);
    }
}

