/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.commands;

import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj2.command.CommandBase;
import edu.wpi.first.wpilibj2.command.Subsystem;

public class RunnableCommand
extends CommandBase {
    private final Timer timer = new Timer();
    private final Runnable init;
    private final Runnable end;
    private final double durationSeconds;
    private boolean runsWhileDisabled = false;

    public RunnableCommand(Runnable init, Runnable end, double durationSeconds, Subsystem ... toRequire) {
        this.init = init;
        this.end = end;
        this.durationSeconds = durationSeconds;
        this.addRequirements(toRequire);
    }

    public RunnableCommand(Runnable init, Subsystem ... toRequire) {
        this(init, null, 0.0, new Subsystem[0]);
        this.addRequirements(toRequire);
    }

    public void setRunsWhileDisabled(boolean runsWhileDisabled) {
        this.runsWhileDisabled = runsWhileDisabled;
    }

    public boolean runsWhenDisabled() {
        return this.runsWhileDisabled;
    }

    public void initialize() {
        this.timer.reset();
        this.timer.start();
        if (this.init != null) {
            this.init.run();
        }
    }

    public void end(boolean interrupted) {
        if (this.end != null) {
            this.end.run();
        }
    }

    public boolean isFinished() {
        return this.durationSeconds >= 0.0 && this.timer.get() >= this.durationSeconds;
    }
}

