/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.commands;

import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj2.command.CommandBase;
import edu.wpi.first.wpilibj2.command.Subsystem;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.chsrobotics.lib.util.Tuple2;

public class ConditionalConsumerCommand<T>
extends CommandBase {
    private final boolean isBiConsumer;
    private final Consumer<T> consumer;
    private final BiConsumer<T, T> biConsumer;
    private final Supplier<Boolean> conditional;
    private final double durationSeconds;
    private final Timer timer = new Timer();
    private final T onTrue;
    private final T onFalse;
    private final Tuple2<T> biOnTrue;
    private final Tuple2<T> biOnFalse;
    private boolean runsWhileDisabled = false;
    private boolean lastConditionalValue;

    public ConditionalConsumerCommand(Consumer<T> consumer, T onTrue, T onFalse, Supplier<Boolean> conditional, double durationSeconds, Subsystem ... toRequire) {
        this.isBiConsumer = false;
        this.consumer = consumer;
        this.biConsumer = null;
        this.onTrue = onTrue;
        this.onFalse = onFalse;
        this.biOnTrue = null;
        this.biOnFalse = null;
        this.durationSeconds = durationSeconds;
        this.conditional = conditional;
        this.lastConditionalValue = conditional.get();
        this.addRequirements(toRequire);
    }

    public ConditionalConsumerCommand(Consumer<T> consumer, T onTrue, T onFalse, Supplier<Boolean> conditional, Subsystem ... toRequire) {
        this(consumer, onTrue, onFalse, conditional, -1.0, toRequire);
    }

    public ConditionalConsumerCommand(BiConsumer<T, T> biConsumer, Tuple2<T> onTrue, Tuple2<T> onFalse, double durationSeconds, Supplier<Boolean> conditional, Subsystem ... toRequire) {
        this.isBiConsumer = true;
        this.biConsumer = biConsumer;
        this.consumer = null;
        this.onTrue = null;
        this.onFalse = null;
        this.biOnTrue = onTrue;
        this.biOnFalse = onFalse;
        this.durationSeconds = durationSeconds;
        this.conditional = conditional;
        this.addRequirements(toRequire);
    }

    public ConditionalConsumerCommand(BiConsumer<T, T> consumer, Tuple2<T> onTrue, Tuple2<T> onFalse, Supplier<Boolean> conditional, Subsystem ... toRequire) {
        this(consumer, onTrue, onFalse, -1.0, conditional, toRequire);
    }

    public void setRunsWhileDisabled(boolean runsWhileDisabled) {
        this.runsWhileDisabled = runsWhileDisabled;
    }

    public boolean runsWhenDisabled() {
        return this.runsWhileDisabled;
    }

    public void execute() {
        boolean value = this.conditional.get();
        if (!this.lastConditionalValue && value && this.onTrue != null) {
            if (this.isBiConsumer) {
                this.biConsumer.accept(this.biOnTrue.firstValue(), this.biOnTrue.secondValue());
            } else {
                this.consumer.accept(this.onTrue);
            }
        } else if (this.lastConditionalValue && !value && this.onFalse != null) {
            if (this.isBiConsumer) {
                this.biConsumer.accept(this.biOnFalse.firstValue(), this.biOnFalse.secondValue());
            } else {
                this.consumer.accept(this.onFalse);
            }
        }
        this.lastConditionalValue = value;
    }

    public void initialize() {
        this.timer.reset();
        this.timer.start();
    }

    public boolean isFinished() {
        return this.durationSeconds >= 0.0 && this.timer.get() >= this.durationSeconds;
    }
}

