/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.util;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.RobotBase;
import edu.wpi.first.wpilibj.TimedRobot;

public class SRobot {
    private static RobotState currentState = RobotState.NONE;

    public final void start() {
        RobotBase.startRobot(() -> new WrappedTimedRobot());
    }

    public void stateTransition(RobotState from, RobotState to) {
    }

    public void periodic(RobotState state) {
    }

    public static final boolean isReal() {
        return WrappedTimedRobot.isReal();
    }

    public static final double getPeriodSeconds() {
        return 0.02;
    }

    public static final RobotState getRobotState() {
        return currentState;
    }

    private class WrappedTimedRobot
    extends TimedRobot {
        private WrappedTimedRobot() {
        }

        public void teleopInit() {
            SRobot.this.stateTransition(currentState, RobotState.TELEOPERATED);
            currentState = RobotState.TELEOPERATED;
        }

        public void autonomousInit() {
            SRobot.this.stateTransition(currentState, RobotState.AUTONOMOUS);
            currentState = RobotState.AUTONOMOUS;
        }

        public void testInit() {
            SRobot.this.stateTransition(currentState, RobotState.TEST);
            currentState = RobotState.TEST;
        }

        public void disabledInit() {
            if (DriverStation.isEStopped()) {
                SRobot.this.stateTransition(currentState, RobotState.ESTOPPED);
                currentState = RobotState.ESTOPPED;
            } else {
                SRobot.this.stateTransition(currentState, RobotState.DISABLED);
                currentState = RobotState.DISABLED;
            }
        }

        public void robotPeriodic() {
            SRobot.this.periodic(currentState);
        }
    }

    public static enum RobotState {
        TELEOPERATED,
        AUTONOMOUS,
        TEST,
        DISABLED,
        ESTOPPED,
        NONE;

    }
}

