/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.telemetry;

import edu.wpi.first.networktables.NetworkTable;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.util.datalog.DataLog;
import edu.wpi.first.util.sendable.Sendable;
import edu.wpi.first.util.sendable.SendableBuilder;
import edu.wpi.first.util.sendable.SendableRegistry;
import edu.wpi.first.wpilibj.DataLogManager;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.Filesystem;
import edu.wpi.first.wpilibj.RobotBase;
import edu.wpi.first.wpilibj.RobotController;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilderImpl;
import edu.wpi.first.wpilibj2.command.Command;
import edu.wpi.first.wpilibj2.command.CommandScheduler;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.chsrobotics.lib.telemetry.IntrinsicLoggable;
import org.chsrobotics.lib.telemetry.Logger;

public class HighLevelLogger
implements IntrinsicLoggable {
    private static HighLevelLogger instance = new HighLevelLogger();
    private boolean hasStarted = false;
    private final String commitDataFilename = "commit.txt";
    private final String branchDataFilename = "branch.txt";
    private final HashMap<Command, Timer> commandTimeMap = new HashMap();
    private int brownoutCounter = 0;
    private Logger<String[]> scheduledCommandsLogger;
    private Logger<Boolean> isBrownedOutLogger;
    private Logger<Double> canUtilizationLogger;
    private Logger<Double> batteryVoltageLogger;
    private Logger<Double> logger3_3vCurrent;
    private Logger<Double> logger5vCurrent;
    private Logger<Integer> brownoutCountLogger;
    private boolean loggersConstructed = false;
    private final NetworkTable sendables = NetworkTableInstance.getDefault().getTable("sendables");
    private final Map<String, Sendable> tablesToData = new HashMap<String, Sendable>();

    private HighLevelLogger() {
    }

    public static HighLevelLogger getInstance() {
        return instance;
    }

    public void startLogging() {
        if (!this.hasStarted) {
            CommandScheduler.getInstance().onCommandInitialize(HighLevelLogger.getInstance()::logCommandInit);
            CommandScheduler.getInstance().onCommandFinish(HighLevelLogger.getInstance()::logCommandFinished);
            CommandScheduler.getInstance().onCommandInterrupt(HighLevelLogger.getInstance()::logCommandInterrupted);
            this.hasStarted = true;
            DataLogManager.logNetworkTables((boolean)false);
            this.logMessage("Log init");
            this.logMessage("Real time: " + LocalDateTime.now().toString());
            this.logMessage("Robot is: " + (RobotBase.isReal() ? "real" : "simulated"));
            this.logMessage("Event: " + (DriverStation.isFMSAttached() ? DriverStation.getEventName() : "N/A"));
            this.logMessage("Match type: " + (DriverStation.isFMSAttached() ? DriverStation.getMatchType().toString() : "N/A"));
            this.logMessage("Match number: " + (Serializable)(DriverStation.isFMSAttached() ? Integer.valueOf(DriverStation.getMatchNumber()) : "N/A"));
            try {
                File commitTxt = new File(Filesystem.getDeployDirectory(), "commit.txt");
                File branchTxt = new File(Filesystem.getDeployDirectory(), "branch.txt");
                this.logMessage("Git commit: " + Files.readString(commitTxt.toPath()));
                this.logMessage("Git branch: " + Files.readString(branchTxt.toPath()));
            }
            catch (IOException exc) {
                this.logMessage("Git branch / commit data could not be read!");
            }
        }
    }

    public DataLog getLog() {
        if (!this.hasStarted) {
            this.startLogging();
        }
        return DataLogManager.getLog();
    }

    public void logMessage(String message) {
        if (!this.hasStarted) {
            this.startLogging();
        }
        DataLogManager.log((String)message);
    }

    public void logWarning(String message) {
        this.logMessage("WARNING " + message);
        DriverStation.reportWarning((String)message, (boolean)false);
    }

    public void logError(String message) {
        this.logMessage("ERROR " + message);
        DriverStation.reportError((String)message, (boolean)false);
    }

    public synchronized void publishSendable(String key, Sendable data) {
        Sendable sddata = this.tablesToData.get(key);
        if (sddata == null || sddata != data) {
            this.tablesToData.put(key, data);
            NetworkTable dataTable = this.sendables.getSubTable(key);
            SendableBuilderImpl builder = new SendableBuilderImpl();
            builder.setTable(dataTable);
            SendableRegistry.publish((Sendable)data, (SendableBuilder)builder);
            builder.startListeners();
            dataTable.getEntry(".name").setString(key);
        }
    }

    @Override
    public void autoGenerateLogs(DataLog log, String name, String subdirName, boolean publishToNT, boolean recordInLog) {
        if (!this.loggersConstructed) {
            Logger.LoggerFactory doubleLogFactory = new Logger.LoggerFactory(log, "system", publishToNT, recordInLog);
            this.scheduledCommandsLogger = new Logger("scheduledCommands", "commandScheduler");
            this.isBrownedOutLogger = new Logger("isBrownedOut", "system");
            this.canUtilizationLogger = doubleLogFactory.getLogger("canUtilitzation_percent");
            this.batteryVoltageLogger = doubleLogFactory.getLogger("batteryVoltage_volts");
            this.logger3_3vCurrent = doubleLogFactory.getLogger("3.3vCurrent_amps");
            this.logger5vCurrent = doubleLogFactory.getLogger("5vCurrent_amps");
            this.brownoutCountLogger = new Logger("brownoutCount", "system");
            this.loggersConstructed = true;
        }
    }

    @Override
    public void updateLogs() {
        if (!this.loggersConstructed) {
            if (RobotController.getBatteryVoltage() < RobotController.getBrownoutVoltage()) {
                ++this.brownoutCounter;
            }
        } else {
            ArrayList<String> commands = new ArrayList<String>();
            for (Command command : this.commandTimeMap.keySet()) {
                commands.add(command.getName());
            }
            this.scheduledCommandsLogger.update(commands.toArray(new String[0]));
            if (RobotController.getBatteryVoltage() < RobotController.getBrownoutVoltage()) {
                ++this.brownoutCounter;
                this.isBrownedOutLogger.update(true);
            } else {
                this.isBrownedOutLogger.update(false);
            }
            this.brownoutCountLogger.update(this.brownoutCounter);
            this.canUtilizationLogger.update(RobotController.getCANStatus().percentBusUtilization);
            this.batteryVoltageLogger.update(RobotController.getBatteryVoltage());
            this.logger3_3vCurrent.update(RobotController.getCurrent3V3());
            this.logger5vCurrent.update(RobotController.getCurrent5V());
        }
    }

    private void logCommandInit(Command command) {
        this.logMessage("Command initialized: " + command.getName());
        Timer timer = new Timer();
        timer.reset();
        timer.start();
        this.commandTimeMap.put(command, timer);
    }

    private void logCommandFinished(Command command) {
        this.logMessage("Command finished after " + this.commandTimeMap.get(command).get() + " seconds: " + command.getName());
        this.commandTimeMap.remove(command);
    }

    private void logCommandInterrupted(Command command) {
        this.logMessage("Command interrupted after " + this.commandTimeMap.get(command).get() + " seconds: " + command.getName());
        this.commandTimeMap.remove(command);
    }
}

