/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.geometry;

import java.util.Objects;

public class Vector3D {
    private final double x;
    private final double y;
    private final double z;

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getMagnitude() {
        return Math.sqrt(this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ());
    }

    public Vector3D add(Vector3D other) {
        return new Vector3D(this.getX() + other.getX(), this.getY() + other.getY(), this.getZ() + other.getZ());
    }

    public Vector3D subtract(Vector3D other) {
        return this.add(other.scalarMultiply(-1.0));
    }

    public double dotProduct(Vector3D other) {
        return this.getX() * other.getX() + this.getY() * other.getY() + this.getZ() * other.getZ();
    }

    public Vector3D crossProduct(Vector3D other) {
        double xSum = this.getY() * other.getZ() - this.getZ() * other.getY();
        double ySum = this.getZ() * other.getX() - this.getX() * other.getZ();
        double zSum = this.getX() * other.getY() - this.getY() * other.getX();
        return new Vector3D(xSum, ySum, zSum);
    }

    public Vector3D scalarMultiply(double scalar) {
        return new Vector3D(this.getX() * scalar, this.getY() * scalar, this.getZ() * scalar);
    }

    public Vector3D scalarDivide(double scalar) {
        if (scalar == 0.0) {
            return this;
        }
        return this.scalarMultiply(1.0 / scalar);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean equals(Object other) {
        if (other instanceof Vector3D) {
            Vector3D rhs = (Vector3D)other;
            return this.getX() == rhs.getX() && this.getY() == rhs.getY() && this.getZ() == rhs.getZ();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getX(), this.getY(), this.getZ());
    }

    public String toString() {
        return "Vector: x " + this.getX() + ", y " + this.getY() + ", z " + this.getZ();
    }
}

