/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.geometry;

import java.util.ArrayList;
import org.chsrobotics.lib.math.geometry.Line2D;
import org.chsrobotics.lib.math.geometry.Vector2D;

public class Polygon {
    private final Vector2D[] vertices;

    public Polygon(Vector2D ... vertices) {
        this.vertices = vertices;
    }

    public boolean pointLiesWithin(Vector2D point) {
        if (this.vertices.length == 0) {
            return false;
        }
        ArrayList<Line2D> sides = new ArrayList<Line2D>();
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            sides.add(new Line2D(this.vertices[i], this.vertices[i + 1]));
        }
        sides.add(new Line2D(this.vertices[this.vertices.length - 1], this.vertices[0]));
        for (Line2D side : sides) {
            if (!side.pointOn(point)) continue;
            return true;
        }
        Line2D projection = new Line2D(point, new Vector2D(point.getX() + 2.147483647E9, point.getY()));
        int intersectionCounter = 0;
        for (Line2D side : sides) {
            if (!side.intersects(projection) || side.getDirectionRadians() == Math.PI || side.getDirectionRadians() == 0.0) continue;
            ++intersectionCounter;
        }
        return intersectionCounter % 2 == 1;
    }
}

